--liquibase formatted sql
--changeset ales.holec:240205T2214

-- Refactoring of bonus 1.
-- Bunus rules are store in separted table as 1:n where there is always one rule.
-- Copy rule values to configuration and delete rule table.

-- Delete unused columns
ALTER TABLE control.bonus_lpn_basic1_config DROP COLUMN color;
ALTER TABLE control.bonus_lpn_basic1_config DROP COLUMN description;
ALTER TABLE control.bonus_lpn_basic1_config DROP COLUMN title;

ALTER TABLE control.bonus_lpn_basic1_config ADD COLUMN amount numeric(2) NOT NULL DEFAULT 0;
ALTER TABLE control.bonus_lpn_basic1_config ADD COLUMN duration integer NOT NULL DEFAULT 0;
ALTER TABLE control.bonus_lpn_basic1_config ADD COLUMN renew_cron character varying NOT NULL DEFAULT '0 0 0 ? * * *';


COMMENT ON COLUMN control.bonus_lpn_basic1_config.amount IS 'Maximal number of bonuses to give.';
COMMENT ON COLUMN control.bonus_lpn_basic1_config.duration  IS 'Maximal duration of given bonuses.';
COMMENT ON COLUMN control.bonus_lpn_basic1_config.renew_cron  IS 'Quarz cron expression to reset bonus counters.';


-- Copy value from bonus rule (there is always 1) to bonus configuration.
UPDATE control.bonus_lpn_basic1_config
SET 
amount = subquery.b_amount, 
duration = subquery.b_duration, 
renew_cron = subquery.renew_cron
FROM 
(
	SELECT bonus_id, b_duration , b_amount, bonus_lpn_basic1_rule.renew_cron
	FROM control.bonus_lpn_basic1_rule
) AS subquery
WHERE subquery.bonus_id = id;

-- Drop old table.
DROP TABLE control.bonus_lpn_basic1_rule;
