--liquibase formatted sql
--changeset ales.holec:220330T1535

CREATE TABLE control.user_data_file
(
    id SERIAL,
    group_name CHARACTER VARYING NOT NULL,
    file_name CHARACTER VARYING NOT NULL,
    content CHARACTER VARYING NOT NULL,
    created_pdm TIMESTAMP WITH TIME ZONE NOT NULL,
    created_srv TIMESTAMP WITH TIME ZONE NOT NULL,
	size_recieved INTEGER NOT NULL,
	size_anounced INTEGER,
	parts_recieved INTEGER NOT NULL,
	parts_anounced INTEGER,
	canceled BOOLEAN NOT NULL,
	transfer_status INTEGER,
    pdm_id integer NOT NULL,
    data oid NOT NULL,
    CONSTRAINT pk_user_data_file PRIMARY KEY (id),
    CONSTRAINT fk_user_data_file__pdm FOREIGN KEY (pdm_id) REFERENCES control.pdm (pdm_id) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE NOT VALID
);

CREATE INDEX fki_user_data_file__pdm ON control.user_data_file USING btree (pdm_id ASC NULLS LAST);

ALTER TABLE IF EXISTS control.user_data_file ADD CONSTRAINT uk_user_data_file__pdm_group_file UNIQUE (pdm_id, group_name, file_name);
COMMENT ON CONSTRAINT uk_user_data_file__pdm_group_file ON control.user_data_file IS 'Each path must be unique within a PDM.';
