/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.technical;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.ui.controllers.reports.technical.EnergyEntryProjection;
import java.time.LocalDateTime;

class UiEnergyReportRow {
    @JsonProperty(value="pdm")
    private final int pdmId;
    @JsonProperty(value="date")
    private final LocalDateTime time;
    @JsonProperty(value="mSol")
    private final Float mcsSolarInput;
    @JsonProperty(value="sIn")
    private final Float svenInput;
    @JsonProperty(value="sBat")
    private final Float svenBattery;
    @JsonProperty(value="vAvg")
    private final Float volAvg;
    @JsonProperty(value="vMin")
    private final Float volMin;
    @JsonProperty(value="vMax")
    private final Float volMax;
    @JsonProperty(value="vDrop")
    private final Float volDrop;

    public UiEnergyReportRow(EnergyEntryProjection e) {
        this.pdmId = e.getPdm().getId();
        this.time = LocalDateTime.of((int)e.getYear(), e.getMonth(), (int)e.getDay(), 0, 0);
        this.mcsSolarInput = e.getPowMcsSol();
        this.svenInput = e.getPowSvenIn();
        this.svenBattery = e.getPowSvenBat();
        this.volAvg = e.getVolAvg();
        this.volMax = e.getVolMax();
        this.volMin = e.getVolMin();
        this.volDrop = e.getVolDrop();
    }

    public int getPdmId() {
        return this.pdmId;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public Float getMcsSolarInput() {
        return this.mcsSolarInput;
    }

    public Float getSvenInput() {
        return this.svenInput;
    }

    public Float getSvenBattery() {
        return this.svenBattery;
    }

    public Float getVolAvg() {
        return this.volAvg;
    }

    public Float getVolMin() {
        return this.volMin;
    }

    public Float getVolMax() {
        return this.volMax;
    }

    public Float getVolDrop() {
        return this.volDrop;
    }
}

