/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.reports.payments.PaymentReportService;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReport;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportByPdm;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportByPdmReportRow;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportByPdmReportRowHeader;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategory;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategoryQuaterDow;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategoryYearMonth;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategoryYearQuater;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategoryYearWeek;
import de.rtb.pcon.ui.controllers.reports.payments.TableFormatter;
import de.rtb.pcon.ui.controllers.reports.payments.TimeCurrencyTableFormatter;
import de.rtb.pcon.ui.controllers.reports.payments.TimeDurationTableFormatter;
import de.rtb.pcon.ui.controllers.reports.payments.TransactionCollectror;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcontrol.ui.controller.UiConvertHelper;
import de.rtb.pcontrol.utils.ExcelExportHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
@RequestMapping(path={"/api/pcon/ui/report/payments"})
public class ReportPaymentsController {
    @Autowired
    private PdmFilterRepository pdmFilterRepo;
    @Autowired
    private I18nService i18n;
    @Autowired
    private PaymentReportService paymentReportService;

    @GetMapping(value={"/interval/amount.json"})
    @Transactional(readOnly=true)
    @ResponseBody
    public Map<String, Object> paymentIntervalAmountJson(@RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="pt", required=false) Set<Integer> uiPaymentTypes, @RequestParam(value="pr", required=false) Set<Integer> uiPaymentReasons, @RequestParam(value="timeStep", required=false) Integer uiTimeStep, @RequestParam(value="valueStep", required=false) String uiValueStep) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentTypes = UiConvertHelper.convertPaymentTypes(uiPaymentTypes);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        uiValueStep = uiValueStep.replace(",", ".");
        BigDecimal valueStep = new BigDecimal(uiValueStep);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        Map collectors = this.paymentReportService.calculateAmount(from, to, (Collection)pdms, (Collection)paymentTypes, (Collection)paymentReasons, Duration.of(uiTimeStep.intValue(), ChronoUnit.MINUTES), valueStep);
        HashMap<String, String[][]> uiResultTables = new HashMap<String, String[][]>();
        for (Map.Entry entry : collectors.entrySet()) {
            String currency = (String)entry.getKey();
            TransactionCollectror collector = (TransactionCollectror)entry.getValue();
            TimeCurrencyTableFormatter tableFormatter = new TimeCurrencyTableFormatter(this.i18n);
            String[][] uiTableData = collector.histogramTable((TableFormatter)tableFormatter);
            uiResultTables.put(currency, uiTableData);
        }
        return Map.of("tables", uiResultTables);
    }

    @GetMapping(value={"/interval/amount.xlsx"})
    @Transactional(readOnly=true)
    public void paymentIntervalAmountExcel(HttpServletResponse response, @RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="pt", required=false) Set<Integer> uiPaymentTypes, @RequestParam(value="pr", required=false) Set<Integer> uiPaymentReasons, @RequestParam(value="timeStep", required=false) Integer uiTimeStep, @RequestParam(value="valueStep", required=false) String uiValueStep) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentTypes = UiConvertHelper.convertPaymentTypes(uiPaymentTypes);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        uiValueStep = uiValueStep.replace(",", ".");
        BigDecimal valueStep = new BigDecimal(uiValueStep);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        Map collectors = this.paymentReportService.calculateAmount(from, to, (Collection)pdms, (Collection)paymentTypes, (Collection)paymentReasons, Duration.of(uiTimeStep.intValue(), ChronoUnit.MINUTES), valueStep);
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            XSSFCellStyle headerRowCellStyle = eeh.createHeaderRowStyle();
            XSSFCellStyle headerColCellStyle = eeh.createHeaderColStyle();
            for (String currency : collectors.keySet()) {
                XSSFSheet sheet = workbook.createSheet(currency);
                TimeCurrencyTableFormatter tableFormatter = new TimeCurrencyTableFormatter(this.i18n);
                TransactionCollectror collector = (TransactionCollectror)collectors.get(currency);
                String[][] uiTableData = collector.histogramTable((TableFormatter)tableFormatter);
                for (int i = 0; i < uiTableData.length; ++i) {
                    XSSFRow row = sheet.createRow(i);
                    for (int j = 0; j < uiTableData[i].length; ++j) {
                        XSSFCell cell = row.createCell(j);
                        if (i == 0 || j == 0) {
                            if (i == 0 && j != 0) {
                                cell.setCellStyle((CellStyle)headerRowCellStyle);
                            } else if (i != 0 && j == 0) {
                                cell.setCellStyle((CellStyle)headerColCellStyle);
                            }
                            cell.setCellValue(uiTableData[i][j]);
                            continue;
                        }
                        cell.setCellValue((double)Integer.parseInt(uiTableData[i][j]));
                    }
                }
                ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
                sheet.createFreezePane(1, 1);
            }
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.payments.intervalAmount.export.filename", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/interval/duration.json"})
    @ResponseBody
    public String[][] paymentIntervalDurationData(@RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="pt", required=false) Set<Integer> uiPaymentTypes, @RequestParam(value="pr", required=false) Set<Integer> uiPaymentReasons, @RequestParam(value="timeStep", required=false) Integer uiTimeStep, @RequestParam(value="durationStep", required=false) Integer uiDurationStep) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentTypes = UiConvertHelper.convertPaymentTypes(uiPaymentTypes);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        Duration timeStep = Duration.of(uiTimeStep.intValue(), ChronoUnit.MINUTES);
        Duration valueStep = Duration.of(uiDurationStep.intValue(), ChronoUnit.MINUTES);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        TransactionCollectror collector = this.paymentReportService.calculateDuration(from, to, (Collection)pdms, (Collection)paymentTypes, (Collection)paymentReasons, timeStep, valueStep);
        Locale userLocale = this.i18n.getUserLocale();
        TimeDurationTableFormatter tableFormatter = new TimeDurationTableFormatter(userLocale);
        return collector.histogramTable((TableFormatter)tableFormatter);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/interval/duration.xlsx"})
    public void paymentIntervalDurationExcel(HttpServletResponse response, @RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="pt", required=false) Set<Integer> uiPaymentTypes, @RequestParam(value="pr", required=false) Set<Integer> uiPaymentReasons, @RequestParam(value="timeStep", required=false) Integer uiTimeStep, @RequestParam(value="durationStep", required=false) Integer uiDurationStep) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentTypes = UiConvertHelper.convertPaymentTypes(uiPaymentTypes);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        Duration timeStep = Duration.of(uiTimeStep.intValue(), ChronoUnit.MINUTES);
        Duration valueStep = Duration.of(uiDurationStep.intValue(), ChronoUnit.MINUTES);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        TransactionCollectror collector = this.paymentReportService.calculateDuration(from, to, (Collection)pdms, (Collection)paymentTypes, (Collection)paymentReasons, timeStep, valueStep);
        Locale userLocale = this.i18n.getUserLocale();
        TimeDurationTableFormatter tableFormatter = new TimeDurationTableFormatter(userLocale);
        String[][] uiTableData = collector.histogramTable((TableFormatter)tableFormatter);
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            XSSFCellStyle headerRowCellStyle = eeh.createHeaderRowStyle();
            XSSFCellStyle headerColCellStyle = eeh.createHeaderColStyle();
            XSSFSheet sheet = workbook.createSheet();
            for (int i = 0; i < uiTableData.length; ++i) {
                XSSFRow row = sheet.createRow(i);
                for (int j = 0; j < uiTableData[i].length; ++j) {
                    XSSFCell cell = row.createCell(j);
                    if (i == 0 || j == 0) {
                        if (i == 0 && j != 0) {
                            cell.setCellStyle((CellStyle)headerRowCellStyle);
                        } else if (i != 0 && j == 0) {
                            cell.setCellStyle((CellStyle)headerColCellStyle);
                        }
                        cell.setCellValue(uiTableData[i][j]);
                        continue;
                    }
                    cell.setCellValue((double)Integer.parseInt(uiTableData[i][j]));
                }
            }
            ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            sheet.createFreezePane(1, 1);
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.payments.intervalDuration.export.filename", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"ticket-sale.json"})
    @ResponseBody
    public Map<String, Object> paymentTickeySaleJson(@RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="grouping", required=true) String uiGroupingName) {
        boolean showEmptyHours = true;
        boolean showEmptyCategories = true;
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        LocalDateTime from = UiConvertHelper.truncateFrom((LocalDateTime)uiFrom);
        SaleReport reportData = this.paymentReportService.calculateSales(from, uiTo, (Collection)pdms, this.stringToRowCategory(uiGroupingName));
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedList<String> uiLabels = new LinkedList<String>();
        for (Integer hour : reportData.calculateUsedHours(showEmptyHours)) {
            uiLabels.add(Integer.toString(hour));
        }
        LinkedList uiCurrencies = new LinkedList(reportData.getCurrencies());
        LinkedList uiResultTable = new LinkedList();
        for (Object category : reportData.getCategories(showEmptyCategories)) {
            LinkedList<BigDecimal> uiRow = new LinkedList<BigDecimal>();
            for (Integer hour : reportData.calculateUsedHours(showEmptyHours)) {
                int ticketCount = reportData.getTicketCount((SaleReportRowCategory)category, hour.intValue());
                uiRow.add(new BigDecimal(ticketCount));
            }
            uiResultTable.add(uiRow);
        }
        LinkedList<String> uiCategoryLabels = new LinkedList<String>();
        for (Object category : reportData.getCategories(showEmptyCategories)) {
            uiCategoryLabels.add(category.toLocaleString(this.i18n.getUserLocale()));
        }
        LinkedList uiSideRowsTable = new LinkedList();
        for (SaleReportRowCategory category : reportData.getCategories(showEmptyCategories)) {
            LinkedList<BigDecimal> uiRow = new LinkedList<BigDecimal>();
            int soldCount = 0;
            for (Integer hour : reportData.calculateUsedHours(showEmptyHours)) {
                int ticketCount = reportData.getTicketCount(category, hour.intValue());
                soldCount += ticketCount;
            }
            uiRow.add(new BigDecimal(soldCount));
            for (String currency : uiCurrencies) {
                BigDecimal soldValue = reportData.getTicketValue(category, currency);
                if (BigDecimal.ZERO.compareTo(soldValue) != 0) {
                    uiRow.add(soldValue);
                    continue;
                }
                uiRow.add(BigDecimal.ZERO);
            }
            uiSideRowsTable.add(uiRow);
        }
        LinkedList<BigDecimal> uiSoldSummary = new LinkedList<BigDecimal>();
        int totalSoldCount = 0;
        for (Integer hour : reportData.calculateUsedHours(showEmptyHours)) {
            int count = reportData.getTicketCount(hour.intValue());
            uiSoldSummary.add(new BigDecimal(count));
            totalSoldCount += count;
        }
        uiSoldSummary.add(new BigDecimal(totalSoldCount));
        for (String cs : reportData.getCurrencies()) {
            uiSoldSummary.add(reportData.getTicketValue(cs));
        }
        result.put("header", uiLabels);
        result.put("currencies", uiCurrencies);
        result.put("categories", uiCategoryLabels);
        result.put("mainRows", uiResultTable);
        result.put("sideRows", uiSideRowsTable);
        result.put("maxTicketCount", reportData.getMaxTicketCount());
        result.put("footer", uiSoldSummary);
        return result;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"ticket-sale.xlsx"})
    public void paymentTicketSaleExcel(HttpServletResponse response, @RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="grouping", required=true) String uiGroupingName) throws IOException {
        boolean showEmptyHours = true;
        boolean showEmptyCategories = true;
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        LocalDateTime from = UiConvertHelper.truncateFrom((LocalDateTime)uiFrom);
        SaleReport reportData = this.paymentReportService.calculateSales(from, uiTo, (Collection)pdms, this.stringToRowCategory(uiGroupingName));
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            XSSFCellStyle headerRowCellStyle = eeh.createHeaderRowStyle();
            XSSFCellStyle headerColCellStyle = eeh.createHeaderColStyle();
            XSSFSheet sheet = workbook.createSheet();
            int rowNr = 0;
            int cellNr = 0;
            XSSFRow row = sheet.createRow(rowNr++);
            Cell cell = row.createCell(cellNr++);
            String statLocalizedName = this.i18n.getLocalizedMessage("report.transaction.tourist.grouping." + uiGroupingName.toLowerCase(), new Object[0]);
            cell.setCellValue(this.i18n.getLocalizedMessage("report.transaction.tourist.table.cornerCell", new Object[]{statLocalizedName}));
            cell.setCellStyle((CellStyle)headerRowCellStyle);
            for (Integer hour : reportData.calculateUsedHours(showEmptyHours)) {
                cell = row.createCell(cellNr++);
                cell.setCellValue((double)hour.intValue());
                cell.setCellStyle((CellStyle)headerRowCellStyle);
            }
            cell = row.createCell(cellNr++);
            cell.setCellValue(this.i18n.getLocalizedMessage("report.transaction.tourist.tickets", new Object[0]));
            cell.setCellStyle((CellStyle)headerRowCellStyle);
            for (String currency : reportData.getCurrencies()) {
                cell = row.createCell(cellNr++);
                cell.setCellValue(this.i18n.getCurrencySymbol(currency));
                cell.setCellStyle((CellStyle)headerRowCellStyle);
            }
            for (SaleReportRowCategory category : reportData.getCategories(showEmptyCategories)) {
                row = sheet.createRow(rowNr++);
                cellNr = 0;
                cell = row.createCell(cellNr++);
                cell.setCellValue(category.toLocaleString(this.i18n.getUserLocale()));
                cell.setCellStyle((CellStyle)headerColCellStyle);
                for (Integer hour : reportData.calculateUsedHours(showEmptyHours)) {
                    cell = row.createCell(cellNr++);
                    int ticketCount = reportData.getTicketCount(category, hour.intValue());
                    if (ticketCount == 0) {
                        cell.setBlank();
                        continue;
                    }
                    cell.setCellValue((double)ticketCount);
                }
                int hourCount = reportData.getHighestHour() - reportData.getLowestHour() + 1;
                cell = row.createCell(cellNr++, CellType.FORMULA);
                String formula = String.format("SUM(B%d:%s%d)", rowNr, CellReference.convertNumToColString((int)hourCount), rowNr);
                cell.setCellFormula(formula);
                for (String currency : reportData.getCurrencies()) {
                    cell = row.createCell(cellNr++);
                    cell.setCellValue(reportData.getTicketValue(category, currency).doubleValue());
                }
            }
            int lastCellNum = row.getLastCellNum();
            row = sheet.createRow(rowNr++);
            cellNr = 0;
            cell = row.createCell(cellNr++);
            cell.setCellValue(this.i18n.getLocalizedMessage("global.label.total", new Object[0]));
            cell.setCellStyle((CellStyle)headerColCellStyle);
            while (cellNr < lastCellNum) {
                String colRef = CellReference.convertNumToColString((int)cellNr);
                cell = row.createCell(cellNr, CellType.FORMULA);
                cell.setCellFormula(String.format("SUM(%s%d:%s%d)", colRef, 2, colRef, rowNr - 1));
                ++cellNr;
            }
            workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
            ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            sheet.createFreezePane(1, 1);
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.payments.ticketSale.export.filename", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"ticket-sale-pdm.json"})
    @ResponseBody
    public Map<String, Object> paymentTicketSaleByPdmJson(@RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pdms", required=false) String uiPdmSelector) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        SaleReportByPdm reportData = this.paymentReportService.calculateSalesByPdm(uiFrom, uiTo, (Collection)pdms);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("headers", reportData.colHeaders());
        result.put("rows", reportData.tableData());
        return result;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"ticket-sale-pdm.xlsx"})
    public void paymentTicketSaleByPdmExcel(HttpServletResponse response, @RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pdms", required=false) String uiPdmSelector) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        SaleReportByPdm reportData = this.paymentReportService.calculateSalesByPdm(uiFrom, uiTo, (Collection)pdms);
        Map pdmMap = pdms.stream().collect(Collectors.toMap(Pdm::getId, Function.identity()));
        Comparator<SaleReportByPdmReportRow> cmpPdmAreaId = Comparator.comparing(row -> (Pdm)pdmMap.get(row.getPdmId()), (a, b) -> Integer.compare(a.getZone().getArea().getId(), b.getZone().getArea().getId()));
        Comparator<SaleReportByPdmReportRow> cmpPdmNumber = Comparator.comparing(row -> (Pdm)pdmMap.get(row.getPdmId()), (a, b) -> Integer.compare(a.getNumber(), b.getNumber()));
        Comparator<SaleReportByPdmReportRow> rowComparator = cmpPdmAreaId.thenComparing(cmpPdmNumber).thenComparing(SaleReportByPdmReportRowHeader.timeComparator);
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            Cell cell;
            XSSFCellStyle headerRowCellStyle = eeh.createHeaderRowStyle();
            XSSFCellStyle headerColCellStyle = eeh.createHeaderColStyle();
            headerColCellStyle.getFont().setBold(false);
            XSSFSheet sheet = workbook.createSheet("PSA_Bezahlungsvorg\u00e4nge_Anzahl");
            int rowNr = 0;
            int cellNr = 0;
            XSSFRow row2 = sheet.createRow(rowNr++);
            List<String> fixedColLabels = List.of(this.i18n.getLocalizedMessage("comp.table.header.label.pdmNumber", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.gac", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.year", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.week", new Object[0]));
            for (String label : fixedColLabels) {
                cell = row2.createCell(cellNr++, CellType.STRING);
                cell.setCellValue(label);
                cell.setCellStyle((CellStyle)headerRowCellStyle);
            }
            for (Integer hour : reportData.colHeaders()) {
                cell = row2.createCell(cellNr++, CellType.NUMERIC);
                cell.setCellValue((double)hour.intValue());
                cell.setCellStyle((CellStyle)headerRowCellStyle);
            }
            for (SaleReportByPdmReportRow dataRow : reportData.tableData().stream().sorted(rowComparator).collect(Collectors.toList())) {
                cellNr = 0;
                row2 = sheet.createRow(rowNr++);
                Optional<Pdm> pdm = pdms.stream().filter(p -> dataRow.getPdmId() == p.getId().intValue()).findAny();
                Cell cell2 = row2.createCell(cellNr++, CellType.NUMERIC);
                cell2.setCellValue((double)pdm.map(Pdm::getNumber).orElse(-1).intValue());
                cell2 = row2.createCell(cellNr++, CellType.NUMERIC);
                cell2.setCellValue((double)pdm.map(p -> p.getZone().getArea().getId()).orElse(-1).intValue());
                cell2 = row2.createCell(cellNr++, CellType.NUMERIC);
                cell2.setCellValue((double)dataRow.getYear());
                cell2 = row2.createCell(cellNr++, CellType.NUMERIC);
                cell2.setCellValue((double)dataRow.getWeek());
                cell2.setCellStyle((CellStyle)headerColCellStyle);
                for (Integer val : dataRow.getData()) {
                    cell2 = row2.createCell(cellNr++, CellType.NUMERIC);
                    cell2.setCellValue((double)val.intValue());
                }
            }
            ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            sheet.createFreezePane(1, 1);
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.payments.ticketSaleByPdm.export.filename", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    private Class<? extends SaleReportRowCategory> stringToRowCategory(String uiCategoryName) {
        return switch (uiCategoryName) {
            case "YEAR-WEEK" -> SaleReportRowCategoryYearWeek.class;
            case "YEAR-MONTH" -> SaleReportRowCategoryYearMonth.class;
            case "YEAR-QUARTER" -> SaleReportRowCategoryYearQuater.class;
            case "QUARTER-DOW" -> SaleReportRowCategoryQuaterDow.class;
            default -> SaleReportRowCategoryYearWeek.class;
        };
    }
}

