/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.core.events.UserUpdatedEvent;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.repositories.AreaRepository;
import de.rtb.pcon.repositories.UserRepository;
import de.rtb.pcon.ui.controllers.AdminUsersController;
import de.rtb.pcon.ui.controllers.model.UiArea;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/admin/users"})
@PreAuthorize(value="hasRole('ROLE_ADMIN_USERS')")
public class AdminUsersController {
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions..SecurityController");
    @Autowired
    private NamedParameterJdbcTemplate jdbcTemplate;
    @Autowired
    private AreaRepository areaRepo;
    @Autowired
    private UserRepository userRepo;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    private static final String SQL_FETCH_USERS = "SELECT usa_id, usa_login, usa_enabled, usa_firstname, usa_lastname, usa_email, usa_timezone, array_agg(distinct user_role.usr_role) as roles, array_agg(distinct area_x_user.area_id) as areas FROM %1$s.user_authentication LEFT JOIN %1$s.user_role ON user_role.usr_user_id = user_authentication.usa_id LEFT JOIN %1$s.area_x_user ON area_x_user.user_id = user_authentication.usa_id GROUP BY usa_id".formatted("control");

    @GetMapping
    public Collection<UserWithRolesAndAreaIdsDto> listUsers(HttpServletResponse response, @RequestParam(name="page", defaultValue="1") int pageNr, @RequestParam(name="size", defaultValue="10") int pageSize, @RequestParam(name="filter", required=false) String filter) {
        HashMap<String, CallSite> countPars = new HashMap<String, CallSite>();
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT count (*) FROM control.user_authentication ");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sqlCount.append("WHERE usa_login ILIKE :filter OR usa_firstname ILIKE :filter OR usa_lastname ILIKE :filter OR usa_email ILIKE :filter ");
            countPars.put("filter", (CallSite)((Object)("%" + filter + "%")));
        }
        long totalUserCount = (Long)this.jdbcTemplate.queryForObject(sqlCount.toString(), (SqlParameterSource)new MapSqlParameterSource(countPars), Long.class);
        long totalPageCount = -Math.floorDiv(-totalUserCount, pageSize);
        response.addHeader("page-total", Long.toString(totalPageCount));
        response.addHeader("page-current", Long.toString(pageNr));
        response.addHeader("page-size", Long.toString(pageSize));
        HashMap<String, Object> dataPars = new HashMap<String, Object>();
        int offset = (pageNr - 1) * pageSize;
        StringBuilder sqlData = new StringBuilder();
        sqlData.append("WITH users AS (" + SQL_FETCH_USERS + ") ");
        sqlData.append("SELECT * FROM users ");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sqlData.append("WHERE usa_login ILIKE :filter OR usa_firstname ILIKE :filter OR usa_lastname ILIKE :filter OR usa_email ILIKE :filter ");
            dataPars.put("filter", "%" + filter + "%");
        }
        sqlData.append("ORDER BY usa_enabled desc, usa_firstname, usa_lastname, usa_login ");
        sqlData.append("OFFSET :offset ");
        sqlData.append("LIMIT :limit");
        dataPars.put("limit", pageSize);
        dataPars.put("offset", offset);
        return this.jdbcTemplate.query(sqlData.toString(), (SqlParameterSource)new MapSqlParameterSource(dataPars), (RowMapper)new UserRowMapper());
    }

    @GetMapping(value={"{id}"})
    public ResponseEntity<UserWithRolesAndAreaIdsDto> getUser(@PathVariable(value="id") int userId) {
        StringBuilder sqlData = new StringBuilder();
        sqlData.append("WITH users AS (" + SQL_FETCH_USERS + ") ");
        sqlData.append("SELECT * FROM users ");
        sqlData.append("WHERE usa_id = " + userId + " ");
        List userList = this.jdbcTemplate.query(sqlData.toString(), (SqlParameterSource)new MapSqlParameterSource(), (RowMapper)new UserRowMapper());
        if (userList.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)((UserWithRolesAndAreaIdsDto)userList.get(0)));
    }

    @PutMapping
    @Transactional
    public ResponseEntity<Object> putUser(@RequestBody UserWithRolesAndAreaIdsDto uiUser) {
        String rolesDiff;
        User user;
        if (uiUser.getId() == null || uiUser.getId() == 0) {
            user = new User();
            user.setAreas(new LinkedList());
        } else {
            Optional oUser = this.userRepo.findById((Object)uiUser.getId());
            if (oUser.isPresent()) {
                user = (User)oUser.get();
            } else {
                return ResponseEntity.notFound().build();
            }
        }
        ArrayList<Object> changelog = new ArrayList<Object>();
        if (!user.isEnabled() == uiUser.isEnabled()) {
            changelog.add("[enabled: '" + user.isEnabled() + "' -> '" + uiUser.isEnabled() + "']");
            user.setEnabled(uiUser.isEnabled());
        }
        if (!StringUtils.equals((CharSequence)user.getLogin(), (CharSequence)uiUser.getLogin())) {
            changelog.add("[login: '" + user.getLogin() + "' -> '" + uiUser.getLogin() + "']");
            user.setLogin(uiUser.getLogin());
        }
        if (!StringUtils.equals((CharSequence)user.getFirstName(), (CharSequence)uiUser.getFirstName())) {
            changelog.add("[first name: '" + user.getFirstName() + "' -> '" + uiUser.getFirstName() + "']");
            user.setFirstName(uiUser.getFirstName());
        }
        if (!StringUtils.equals((CharSequence)user.getLastName(), (CharSequence)uiUser.getLastName())) {
            changelog.add("[last name: '" + user.getLastName() + "' -> '" + uiUser.getLastName() + "']");
            user.setLastName(uiUser.getLastName());
        }
        if (!StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)uiUser.getEmail())) {
            changelog.add("[e-mail: '" + user.getEmail() + "' -> '" + uiUser.getEmail() + "']");
            user.setEmail(uiUser.getEmail());
        }
        if (!StringUtils.equals((CharSequence)user.getTimeZoneName(), (CharSequence)uiUser.getTimeZone())) {
            changelog.add("[time zone: '" + user.getTimeZoneName() + "' -> '" + uiUser.getTimeZone() + "']");
            user.setTimeZoneName(uiUser.getTimeZone());
        }
        if (StringUtils.isNotEmpty((CharSequence)uiUser.getPassword())) {
            changelog.add("[password: CHANGED]");
            user.setPasswordHash(this.passwordEncoder.encode((CharSequence)uiUser.getPassword()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(rolesDiff = LoggerUtils.logCollectionDiffBrief((Collection)user.getRoles(), (Collection)uiUser.getRoles(), p -> p)))) {
            changelog.add("roles [" + rolesDiff + "]");
            user.setRoles(new HashSet(uiUser.getRoles()));
        }
        List areas = IteratorUtils.toList(this.areaRepo.findAllById((Iterable)uiUser.getAreaIds()).iterator());
        String areaDiff = LoggerUtils.logCollectionDiffBrief((Collection)user.getAreas().stream().map(Area::getId).collect(Collectors.toList()), (Collection)uiUser.getAreaIds(), String::valueOf);
        if (StringUtils.isNotEmpty((CharSequence)areaDiff)) {
            changelog.add("areas [" + areaDiff + "]");
            user.setAreas(areas);
        }
        if (actionLogger.isInfoEnabled()) {
            User currentUser = this.securityService.getCurrentUser();
            actionLogger.info("{} has changed properties of {}: {}.", new Object[]{StringUtils.capitalize((String)LoggerUtils.log((User)currentUser)), LoggerUtils.log((User)user), changelog.stream().collect(Collectors.joining(", "))});
        }
        if (user.getId() == null) {
            User savedUser = (User)this.userRepo.save((Object)user);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserUpdatedEvent((Object)this, savedUser.getId().intValue()));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserUpdatedEvent((Object)this, user.getId().intValue()));
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"areas"})
    @Transactional(readOnly=true)
    public Collection<UiArea> listAreas() {
        return StreamSupport.stream(this.areaRepo.findAll().spliterator(), false).map(UiArea::new).toList();
    }
}

