/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.rtb;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.rtb.TicketInfoReq;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.repositories.PaymentTransactionRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class TicketInfoRtr
implements RealTimeRequest {
    @Autowired
    private PaymentTransactionRepository paymentRepo;
    @Autowired
    private PdmRepository pdmRepo;

    TicketInfoRtr() {
    }

    public int getId() {
        return 32;
    }

    public String getDescription() {
        return "Verify ticket";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        TicketInfoReq req = (TicketInfoReq)ctx.getLocalObject(TicketInfoReq.class);
        Optional pdmO = this.pdmRepo.findByNumberAndZoneAreaId(req.pdmNr().intValue(), req.areaNr().intValue());
        if (pdmO.isEmpty()) {
            return Map.of();
        }
        Pdm pdm = (Pdm)pdmO.get();
        ZoneId timeZone = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
        Optional payment = this.paymentRepo.findByIdPdmTimeAndIdPdm(DateTimeUtils.toOffsetDateTime((LocalDateTime)req.timeIssued(), (ZoneId)timeZone), pdm);
        HashMap<String, Object> result = new HashMap<String, Object>();
        payment.ifPresent(p -> result.put("end", DateTimeUtils.toLocalDateTime((OffsetDateTime)p.getParkEndTime(), (ZoneId)timeZone)));
        return result;
    }
}

