/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.touchnet;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.touchnet.OneCardApiService;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigDto;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigService;
import de.rtb.pcon.features.partners.touchnet.OneCardException;
import de.rtb.pcon.features.partners.touchnet.OneCardLoginResponse;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;

@Component
class OneCardRtrLogin
implements RealTimeRequest {
    private final OneCardConfigService configService;
    private final OneCardApiService apiService;

    public OneCardRtrLogin(OneCardConfigService configService, OneCardApiService apiService) {
        this.configService = configService;
        this.apiService = apiService;
    }

    public int getId() {
        return 43;
    }

    public String getDescription() {
        return "OneCard, login";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        String terminalId = ctx.getLocalString("terminalId");
        Pdm pdm = ctx.findPdmEntity();
        try {
            OneCardLoginResponse apiResponse = this.apiService.login(pdm, terminalId);
            return Map.of("sessionId", apiResponse.getSessionId());
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
        catch (OneCardException e) {
            return e.toPdmMnemonicMap();
        }
    }
}

