/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.satispay;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.satispay.SatispayService;
import de.rtb.pcon.model.Pdm;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Map;
import org.jspecify.annotations.NullMarked;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@NullMarked
@Component
class SatispayCratePaymentRtr
implements RealTimeRequest {
    private final SatispayService satispayService;

    public SatispayCratePaymentRtr(SatispayService satispayService) {
        this.satispayService = satispayService;
    }

    public int getId() {
        return 69;
    }

    public String getDescription() {
        return "Satispay, Cancel payment";
    }

    @Transactional
    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Pdm pdm = ctx.findPdmEntity();
        ZoneId pdmTimeZone = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
        BigDecimal amount = BigDecimal.valueOf(ctx.getLocalInteger("amount"), ctx.global().getDpa());
        String currency = ctx.global().getWkz();
        String idempotencyKey = ctx.getLocalString("idempotencyKey");
        OffsetDateTime parkStart = LocalDateTime.parse(ctx.getLocalString("parkStart")).atZone(pdmTimeZone).toOffsetDateTime();
        OffsetDateTime parkEnd = LocalDateTime.parse(ctx.getLocalString("parkEnd")).atZone(pdmTimeZone).toOffsetDateTime();
        return this.satispayService.createPayment(pdm, amount, currency, idempotencyKey, parkStart, parkEnd);
    }
}

