/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoConfigZone;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.features.partners.rao.RaoUtils;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrCompanyIndex
implements RealTimeRequest {
    private final RestClient restClient;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    RaoRtrCompanyIndex(@Qualifier(value="wc3rdPartyApi") RestClient restClient, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 61;
    }

    public String getDescription() {
        return "RAO, company list";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto config = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        try {
            RaoConfigDto raoCfg = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
            Integer zoneId = ctx.findPdmEntity().getZone().getId();
            RaoConfigZone zoneCfg = raoCfg.zones().stream().filter(z -> Objects.equals(z.rtbId(), zoneId)).findAny().orElseThrow(() -> new NoSuchElementException("PDM's zone does not exit in RAO configuration."));
            Pair zoneFilter = Pair.of((Object)raoCfg.zoneIdProperty(), (Object)zoneCfg.raoId());
            Optional townFilter = RaoUtils.createCompletePair((String)config.townProperty(), (String)config.townValue());
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"api", "rao", "articles", "companies"}).queryParam("zoneKey", new Object[]{((String)zoneFilter.getKey()).toUpperCase()}).queryParam("zone", new Object[]{zoneFilter.getValue()});
            townFilter.ifPresent(f -> {
                uriBuilder.queryParam("townKey", new Object[]{((String)f.getKey()).toUpperCase()});
                uriBuilder.queryParam("town", new Object[]{f.getValue()});
            });
            URI uri = uriBuilder.encode().build().toUri();
            Object companies = this.restClient.get().uri(uri).retrieve().body(Object.class);
            return Map.of("httpStatus", 200, "body", companies);
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            return Map.of("ERC", 3, "ERM", "Cannot access Applejack API.");
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

