/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.easy_park;

import com.google.common.base.Objects;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.easy_park.EpAuthService;
import de.rtb.pcon.features.partners.easy_park.EpConfigDto;
import de.rtb.pcon.features.partners.easy_park.EpConfigService;
import de.rtb.pcon.features.partners.easy_park.EpConfigZone;
import de.rtb.pcon.features.partners.easy_park.EpPreviousParkingResponseDto;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class EpPreviousParkingRtr
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(EpPreviousParkingRtr.class);
    private final RestTemplate restTemplate;
    private final EpAuthService epAuthService;
    private final EpConfigService configService;

    public EpPreviousParkingRtr(@Qualifier(value="rt3rdPartyApi") RestTemplate restTemplate, EpAuthService epAuthService, EpConfigService configService) {
        this.restTemplate = restTemplate;
        this.epAuthService = epAuthService;
        this.configService = configService;
    }

    public int getId() {
        return 42;
    }

    public String getDescription() {
        return "Easy park, previous parking";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        String lpn = ctx.getLicensePlate();
        Zone zone = ctx.global().getPdm().getZone();
        log.info("Easy park, previous parking, request received, lpn {}", (Object)lpn);
        EpConfigDto config = (EpConfigDto)this.configService.fetchConfig(zone.getArea());
        if (!config.enabled()) {
            return Map.of("ERC", 1, "ERM", "Bonus is disabled.");
        }
        Optional<EpConfigZone> epZone = config.zones().stream().filter(z -> Objects.equal((Object)z.rtbId(), (Object)zone.getId())).findAny();
        if (epZone.isEmpty() || epZone.get().areaNo() == null) {
            log.atWarn().setMessage("{} is not configured for Easy park. Request is skipped.").addArgument(() -> StringUtils.capitalize((String)LoggerUtils.log((Zone)zone))).log();
            return Map.of("ERM", "Zone is not configured for EasyPark.");
        }
        URI reqUri = UriComponentsBuilder.fromUriString((String)config.general().urlBase()).pathSegment(new String[]{"rest", "resources", "external-api", "parkings", "previous", "v2"}).pathSegment(new String[]{"licenseplate", lpn}).pathSegment(new String[]{"country", config.general().countryCode()}).pathSegment(new String[]{"areano", epZone.get().areaNo().toString()}).queryParam("calculateFreeTime", new Object[]{"true"}).build().encode().toUri();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.set("X-Authorization", this.epAuthService.provideAuthHeaderContent(zone.getArea()));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity httpResponse = this.restTemplate.exchange(reqUri, HttpMethod.GET, request, EpPreviousParkingResponseDto.class);
            if (!httpResponse.getStatusCode().is2xxSuccessful()) {
                return Map.of("ERC", 4, "ERM", "HTTP status " + httpResponse.getStatusCode().value());
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            EpPreviousParkingResponseDto epResp = (EpPreviousParkingResponseDto)httpResponse.getBody();
            if (epResp != null) {
                result.put("ERC", 0);
                result.put("status", epResp.status());
                if (epResp.userErrorString() != null) {
                    result.put("userErrorString", epResp.userErrorString());
                }
                if (epResp.freeTime() != null) {
                    result.put("freeTime", epResp.freeTime());
                }
            } else {
                result.put("ERC", 2);
            }
            return result;
        }
        catch (ResourceAccessException e) {
            log.error("Failed to send request", (Throwable)e);
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

