/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.allgau_card;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.allgau_card.AwcConfigDto;
import de.rtb.pcon.features.partners.allgau_card.AwcConfigService;
import de.rtb.pcon.features.partners.allgau_card.AwcConfigZone;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.zone.Zone;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class AwcRtrCheck
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(AwcRtrCheck.class);
    private final RestClient restClient;
    private final AwcConfigService configService;
    private final String vendorVersion;

    public AwcRtrCheck(AwcConfigService configService, @Qualifier(value="wc3rdPartyApi") RestClient restClient, @Autowired(required=false) BuildProperties buildProperties) {
        this.configService = configService;
        this.restClient = restClient;
        Object pdmControlVersion = "PDM.control ";
        pdmControlVersion = buildProperties != null && buildProperties.getVersion() != null ? (String)pdmControlVersion + buildProperties.getVersion() : (String)pdmControlVersion + "n/a";
        this.vendorVersion = pdmControlVersion;
    }

    public int getId() {
        return 59;
    }

    public String getDescription() {
        return "Allg\u00e4u Walser Card, scan";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Zone zone = ctx.global().getPdm().getZone();
        Area area = zone.getArea();
        String cardId = ctx.getLocalString("KNN");
        Optional mode = ctx.getLocalStringO("mode");
        log.info("Allg\u00e4u Walser Card, scan {}.", (Object)cardId);
        AwcConfigDto config = (AwcConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1, "ERM", "Allg\u00e4u Walser Card service is disabled.");
        }
        Optional<AwcConfigZone> awcZoneProps = config.zones().stream().filter(z -> z.rtbId() == zone.getId()).findAny();
        URI uri = UriComponentsBuilder.fromUriString((String)"https://rtb.tramino.de/api/pass/scan/").queryParam("pass", new Object[]{cardId}).queryParamIfPresent("mode", mode).queryParamIfPresent("location_code", awcZoneProps.map(AwcConfigZone::awcLocationId)).build().encode().toUri();
        try {
            Object traminoRespone = this.restClient.get().uri(uri).header("X-API-Key", new String[]{config.apiKey()}).header("X-Vendor-Key", new String[]{config.vendorKey()}).header("X-Vendor-Version", new String[]{this.vendorVersion}).retrieve().body(Object.class);
            return Map.of("ERC", 0, "response", traminoRespone);
        }
        catch (HttpClientErrorException e) {
            log.debug("Allg\u00e4u Walser Card rejected the card. Status code {}, body {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            return Map.of("ERC", 8, "ERM", e.getStatusCode().value() + " - " + e.getStatusText());
        }
        catch (RestClientException e) {
            log.debug("Allg\u00e4u Walser Card API error: {}", (Object)e.getMessage());
            return Map.of("ERC", 8, "ERM", "API error.");
        }
    }
}

