/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.features.partners.ForeignRegisterConfig;
import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaParner;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.repositories.AreaPartnerRepository;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PartnerConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(PartnerConfigurationService.class);
    @Autowired
    private AreaPartnerRepository configRepo;
    @Autowired
    private ObjectMapper objectMapper;

    public Map<AreaPartnerType, PartnerConfiguration> fetchConfigs(Area area) {
        EnumMap<AreaPartnerType, PartnerConfiguration> partnerConfigs = new EnumMap<AreaPartnerType, PartnerConfiguration>(AreaPartnerType.class);
        for (AreaParner ap : this.configRepo.findByArea(area)) {
            PartnerConfiguration cfg = this.readConfigString(ap.getConfig(), ap.getType(), ap.getType().configClass());
            partnerConfigs.put(ap.getType(), cfg);
        }
        if (log.isDebugEnabled()) {
            String partners = partnerConfigs.keySet().stream().sorted().map(Enum::toString).collect(Collectors.joining(","));
            log.debug("Loaded partner configuration for area {} to cache. Partners: {}", (Object)LoggerUtils.log((Area)area), (Object)partners);
        }
        return partnerConfigs;
    }

    public List<ForeignRegisterConfig> fetchTransportConfig(Area area) {
        EnumMap<AreaPartnerType, ForeignRegisterConfig> transportConfigs = new EnumMap<AreaPartnerType, ForeignRegisterConfig>(AreaPartnerType.class);
        for (AreaParner ap : this.configRepo.findByArea(area)) {
            PartnerConfiguration cfg = this.readConfigString(ap.getConfig(), ap.getType(), ap.getType().configClass());
            if (!(cfg instanceof ForeignRegisterConfig)) continue;
            ForeignRegisterConfig ftc = (ForeignRegisterConfig)cfg;
            if (!cfg.enabled()) continue;
            transportConfigs.put(ap.getType(), ftc);
        }
        if (log.isDebugEnabled()) {
            String partners = transportConfigs.keySet().stream().sorted().map(Enum::toString).collect(Collectors.joining(","));
            log.debug("Loaded payment transport configuration for area {} to cache. Partners: {}", (Object)LoggerUtils.log((Area)area), (Object)partners);
        }
        return List.copyOf(transportConfigs.values());
    }

    @Transactional
    public <T extends PartnerConfiguration> void updateConfig(Area area, T config, AreaPartnerType partnerType) {
        try {
            String json = this.objectMapper.writeValueAsString(config);
            this.configRepo.findByAreaAndType(area, partnerType).ifPresentOrElse(ac -> ac.setConfig(json), () -> {
                AreaParner ac = new AreaParner();
                ac.setArea(area);
                ac.setType(partnerType);
                ac.setConfig(json);
                this.configRepo.save((Object)ac);
            });
        }
        catch (JsonProcessingException e) {
            log.atError().setMessage("Cannot save configuration {}.").addArgument((Object)config.getClass().getSimpleName()).setCause((Throwable)e).log();
        }
        log.debug("Cache evicted.");
    }

    public void deleteConfig(Area area, AreaPartnerType partnerType) {
        this.configRepo.deleteByAreaAndType(area, partnerType);
    }

    private <T extends PartnerConfiguration> T readConfigString(@Nullable String str, AreaPartnerType partnerType, Class<T> configClass) {
        try {
            if (StringUtils.isBlank((CharSequence)str)) {
                return (T)((PartnerConfiguration)configClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            return (T)((PartnerConfiguration)this.objectMapper.readValue(str, configClass));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(MessageFormat.format("Cannot read ''{0}''", partnerType), e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(MessageFormat.format("Cannot create new configuration for partner ''{0}''", partnerType), e);
        }
    }
}

