/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.utils;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.Cron;
import com.cronutils.model.time.ExecutionTime;
import de.rtb.pcon.features.bonus.utils.CronPatternValidationResultUi;
import de.rtb.pcon.features.bonus.utils.CronUtils;
import de.rtb.pcon.ui.services.I18nService;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/utils"})
class UtilityController {
    @Autowired
    private I18nService i18nservice;

    UtilityController() {
    }

    @PostMapping(value={"cronValidator"})
    CronPatternValidationResultUi validateCronPattern(@RequestBody String cronPattern) {
        try {
            ZonedDateTime lastExecution;
            Optional nextExecution;
            Cron cron = CronUtils.CRON_PARSER.parse(cronPattern);
            cron.validate();
            int numberOfFutureExecution = 5;
            ZoneId userTimeZone = this.i18nservice.userTimeZoneId();
            Locale userLocale = this.i18nservice.getUserLocale();
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
            ArrayList<ZonedDateTime> nextExecutionTimes = new ArrayList<ZonedDateTime>(numberOfFutureExecution);
            for (int i = 0; i < numberOfFutureExecution && (nextExecution = executionTime.nextExecution(lastExecution = nextExecutionTimes.isEmpty() ? ZonedDateTime.now(userTimeZone) : (ZonedDateTime)nextExecutionTimes.get(i - 1))).isPresent(); ++i) {
                nextExecutionTimes.add((ZonedDateTime)nextExecution.orElseThrow());
            }
            return CronPatternValidationResultUi.ofValid((String)(StringUtils.capitalize((String)CronDescriptor.instance((Locale)userLocale).describe(cron)) + "."), nextExecutionTimes.stream().map(zdt -> zdt.withZoneSameInstant(userTimeZone).toLocalDateTime()).toList());
        }
        catch (IllegalArgumentException e) {
            return CronPatternValidationResultUi.ofInvalid((String)e.getMessage());
        }
    }
}

