/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.real_time_request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionException;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcontrol.utils.PdmTextEncoder;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class RealTimeRequestRegisterService {
    private static final Logger log = LoggerFactory.getLogger(RealTimeRequestRegisterService.class);
    public static final TypeReference<List<Map<String, Object>>> REQUEST_LIST_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    public static final TypeReference<Map<String, Object>> REQUEST_MAP_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private List<RealTimeRequest> requests;
    private ObjectMapper pdmObjectMapper;

    public RealTimeRequestRegisterService(List<RealTimeRequest> requestsImplementations, @Qualifier(value="pdmObjectMapper") ObjectMapper pdmObjectMapper) {
        this.requests = requestsImplementations;
        this.pdmObjectMapper = pdmObjectMapper;
        log.trace("Found {} real time requests", (Object)requestsImplementations.size());
        this.checkDuplicatedRegistrations(requestsImplementations);
    }

    public Optional<Map<String, Object>> execute(int requestId, PdmMessageDto globalContext, Map<String, Object> localContext) {
        Map localContextNonNull = Objects.requireNonNullElseGet(localContext, Map::of);
        RealTimeRequestExecutionContext context = new RealTimeRequestExecutionContext(globalContext, localContextNonNull, this.pdmObjectMapper);
        Optional<RealTimeRequest> reqImplOpt = this.requests.stream().filter(r -> r.getId() == requestId).findAny();
        if (reqImplOpt.isPresent()) {
            Map<String, CallSite> response;
            HashMap<String, Integer> mm = new HashMap<String, Integer>();
            mm.put("REQ", requestId);
            RealTimeRequest reqImpl = reqImplOpt.get();
            try {
                response = reqImpl.execute(context);
            }
            catch (RealTimeRequestExecutionException e) {
                response = e.getOperationResult();
            }
            catch (Exception e) {
                response = Map.of("ERM", e.getClass().getSimpleName() + ":" + e.getMessage());
                log.error("Exception in real time request", (Throwable)e);
            }
            Map encodedResponse = PdmTextEncoder.encodeMap((Map)response);
            mm.putAll(encodedResponse);
            if (log.isErrorEnabled()) {
                try {
                    log.info(" -> {}: {}", (Object)reqImpl.getDescription(), (Object)this.pdmObjectMapper.writeValueAsString(response));
                }
                catch (JsonProcessingException e) {
                    log.info(" -> {}: {}", (Object)reqImpl.getDescription(), response);
                }
            }
            return Optional.of(mm);
        }
        log.warn("Real time request {} has no implementation. Execution was skipped.", (Object)requestId);
        return Optional.empty();
    }

    public void checkDuplicatedRegistrations(List<RealTimeRequest> discoveredRequestsImplementations) {
        HashSet<Integer> usedIds = new HashSet<Integer>();
        List<RealTimeRequest> sortedImpls = discoveredRequestsImplementations.stream().sorted(Comparator.comparingInt(RealTimeRequest::getId).thenComparing(Comparator.comparing(RealTimeRequest::getDescription))).toList();
        for (RealTimeRequest impl : sortedImpls) {
            if (usedIds.contains(impl.getId())) {
                String prevRegDesc = sortedImpls.stream().filter(im -> im.getId() == impl.getId()).findFirst().map(RealTimeRequest::getDescription).orElse("(Unknown)");
                String errorMsg = MessageFormat.format("Failed to register real time request {0} ({1}). Id {0} is already used by {2},", impl.getId(), impl.getDescription(), prevRegDesc);
                throw new IllegalStateException(errorMsg);
            }
            usedIds.add(impl.getId());
            if (!log.isTraceEnabled()) continue;
            log.trace(String.format(" +  %3d: '%s'.", impl.getId(), impl.getDescription()));
        }
    }
}

