/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.notification;

import com.fasterxml.jackson.databind.JsonNode;
import de.rtb.pcon.core.msg_fw.MessageForwardingRuleDefinition;
import de.rtb.pcon.core.notification.MailProps;
import de.rtb.pcon.core.notification.NotificationProps;
import de.rtb.pcon.core.notification.PriorityResourceLoader;
import de.rtb.pcon.core.notification.TemplatingEngineService;
import de.rtb.pcon.core.notification.ThymeleafStringResolver;
import de.rtb.pcon.features.bonus.utils.JsonUtils;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.data_tables.export.AppProps;
import de.rtb.pcon.ui.services.I18nService;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.FormatStyle;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.LocalizedResourceHelper;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
class TemplatingEngineService {
    private static final Logger log = LoggerFactory.getLogger(TemplatingEngineService.class);
    private static final String INVALID_TEMPLATE_USER_TEXT = "Template is invalid. Please contact your system administrator.";
    private static final Pattern CID_PATTERN = Pattern.compile("cid:([\\w\\-\\.]+)");
    private MailProps mailProps;
    private NotificationProps notificationProps;
    private JavaMailSender javaMailSender;
    private I18nService i18n;
    private TemplateEngine templateEngine;
    private final LocalizedResourceHelper resourceLoaderHelper;
    private final String serverName;
    private final URI serverUri;
    private final URI pconAppUri;

    public TemplatingEngineService(MailProps mailProps, NotificationProps notificationProps, JavaMailSender javaMailSender, I18nService i18n, PriorityResourceLoader resourceLoader, AppProps appProps) throws URISyntaxException {
        this.mailProps = mailProps;
        this.notificationProps = notificationProps;
        this.javaMailSender = javaMailSender;
        this.i18n = i18n;
        this.templateEngine = this.createEmailTemplateEngine();
        this.resourceLoaderHelper = new LocalizedResourceHelper((ResourceLoader)resourceLoader);
        this.serverName = appProps.getName();
        this.serverUri = appProps.getUrl().toURI();
        this.pconAppUri = UriComponentsBuilder.fromUriString((String)appProps.getUrl().toString()).pathSegment(new String[]{"control"}).build().toUri();
    }

    public MimeMessage composePlainTextMessage(String recipient, String subject, String body) {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        try {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, false, StandardCharsets.UTF_8.name());
            message.setFrom(this.mailProps.getFrom());
            message.setTo(recipient);
            message.setSubject(subject);
            message.setText(body);
            return mimeMessage;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create MIME message.", e);
        }
    }

    public MimeMessage composeStatusForwardingMimeMessage(Map<Message.RecipientType, List<String>> recipient, MessageForwardingRuleDefinition rule, StatusMessage status) {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        try {
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, true, StandardCharsets.UTF_8.name());
            mimeMessageHelper.setFrom(this.mailProps.getFrom());
            mimeMessageHelper.setTo(this.extractRecipients(recipient, Message.RecipientType.TO));
            mimeMessageHelper.setCc(this.extractRecipients(recipient, Message.RecipientType.CC));
            mimeMessageHelper.setBcc(this.extractRecipients(recipient, Message.RecipientType.BCC));
            Context ctx = this.createStatusForwardingContext(rule, status);
            this.fillMimeMessageWithCids("status_forwarding", mimeMessageHelper, ctx);
            return mimeMessage;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create MIME message.", e);
        }
    }

    public String[] extractRecipients(Map<Message.RecipientType, List<String>> recipients, Message.RecipientType type) {
        return Optional.ofNullable(recipients.get(type)).map(r -> r.toArray(new String[0])).orElse(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public String composeStatusForwardingSMS(MessageForwardingRuleDefinition rule, StatusMessage status) {
        Context ctx = this.createStatusForwardingContext(rule, status);
        return this.processSingleLineTextTemplate("status_forwarding_sms", ctx);
    }

    public MimeMessage composeLogbookExportMail(File resultFile, User owner, Locale locale) throws MessagingException {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, true, StandardCharsets.UTF_8.name());
        mimeMessageHelper.setFrom(this.mailProps.getFrom());
        mimeMessageHelper.setTo(owner.getEmail());
        boolean attachFile = resultFile.exists() && resultFile.length() < this.notificationProps.getMaxAttachmentSize().toBytes();
        Context ctx = new Context(locale);
        ZoneId userTimeZone = ZoneId.of(owner.getTimeZoneName());
        this.addStandardVariablesToTemplateContext(ctx);
        String downloadUrlString = UriComponentsBuilder.fromUri((URI)this.serverUri).pathSegment(new String[]{"file", "download", "job"}).pathSegment(new String[]{resultFile.toPath().getFileName().toString()}).build().toString();
        ctx.setVariable("downloadUrl", (Object)downloadUrlString);
        ctx.setVariable("fileIsAttached", (Object)attachFile);
        ctx.setVariable("dateTime", (Object)this.i18n.formatTime(FormatStyle.SHORT, ZonedDateTime.now(userTimeZone).toLocalDateTime(), locale));
        this.fillMimeMessageWithCids("logbook_export", mimeMessageHelper, ctx);
        if (attachFile) {
            mimeMessageHelper.addAttachment(resultFile.getName(), resultFile);
        }
        return mimeMessage;
    }

    private Context createStatusForwardingContext(MessageForwardingRuleDefinition rule, StatusMessage status) {
        Pdm pdm = status.getPdm();
        Locale locale = Locale.forLanguageTag(rule.languageTag());
        Context ctx = new Context(locale);
        Map<String, Integer> uriBuilderVars = Map.of("areaId", pdm.getZone().getArea().getId(), "pdmId", pdm.getId(), "ruleId", rule.id());
        this.addStandardVariablesToTemplateContext(ctx);
        ctx.setVariable("alertType", (Object)status.getMessageConfig().getAlertType().name());
        ctx.setVariable("statusText", (Object)this.i18n.getStatusMessageFullText((int)status.getMessageConfig().getNumber().shortValue(), (JsonNode)JsonUtils.readValue((String)status.getReason(), JsonNode.class), locale));
        ctx.setVariable("statusNumber", (Object)status.getMessageConfig().getNumber());
        ctx.setVariable("ruleName", (Object)rule.name());
        UriComponents ruleUric = UriComponentsBuilder.fromUri((URI)this.pconAppUri).pathSegment(new String[]{"areas", "{areaId}", "msgs", "edit", "{ruleId}"}).buildAndExpand(uriBuilderVars);
        ctx.setVariable("ruleUrl", (Object)ruleUric.toUriString());
        ctx.setVariable("pdmName", (Object)pdm.getName());
        ctx.setVariable("pdmNumber", (Object)pdm.getNumber());
        UriComponents pdmUric = UriComponentsBuilder.fromUri((URI)this.pconAppUri).pathSegment(new String[]{"pdms", "{pdmId}", "runtime"}).buildAndExpand(uriBuilderVars);
        ctx.setVariable("pdmUrl", (Object)pdmUric.toUriString());
        ctx.setVariable("areaName", (Object)pdm.getZone().getArea().getName());
        ctx.setVariable("areaNumber", (Object)pdm.getZone().getArea().getId());
        UriComponents areaUric = UriComponentsBuilder.fromUri((URI)this.pconAppUri).pathSegment(new String[]{"areas", "{areaId}", "info"}).buildAndExpand(uriBuilderVars);
        ctx.setVariable("areaUrl", (Object)areaUric.toUriString());
        ctx.setVariable("dateTime", (Object)this.i18n.formatTime(FormatStyle.SHORT, status.getPdmTime(), rule.userTimeZone(), locale));
        ctx.setLocale(locale);
        return ctx;
    }

    private void addStandardVariablesToTemplateContext(Context ctx) {
        ctx.setVariable("serverName", (Object)this.serverName);
        ctx.setVariable("serverUrl", (Object)this.serverUri.toString());
        ctx.setVariable("pconUrl", (Object)this.pconAppUri.toString());
        String[] resPahtSegments = StringUtils.split((String)"/res/notification", (String)"/");
        UriComponents imageUric = UriComponentsBuilder.fromUri((URI)this.serverUri).pathSegment(resPahtSegments).build();
        ctx.setVariable("imageUrl", (Object)imageUric.toUriString());
    }

    private void fillMimeMessageWithCids(String templeteNamePrefix, MimeMessageHelper mimeMessageHelper, Context context) throws MessagingException {
        Resource bodyResource = this.resourceLoaderHelper.findLocalizedResource(templeteNamePrefix + "_body", TemplatingEngineService.templateModeToSuffix((TemplateMode)TemplateMode.HTML), context.getLocale());
        log.debug("Template '{}_body' will be read from '{}'", (Object)templeteNamePrefix, (Object)bodyResource);
        String bodyTemplate = this.readResourceToString(bodyResource);
        mimeMessageHelper.setText(this.processTemplateFromContent(bodyTemplate, TemplateMode.HTML, context), true);
        mimeMessageHelper.setSubject(this.processSingleLineTextTemplate(templeteNamePrefix + "_subject", context));
        this.attachCids(bodyTemplate, context.getLocale(), mimeMessageHelper);
    }

    private void attachCids(String bodyTemplate, Locale locale, MimeMessageHelper mimeMessageHelper) throws MessagingException {
        HashSet<String> cids = new HashSet<String>();
        Matcher cidMatcher = CID_PATTERN.matcher(bodyTemplate);
        while (cidMatcher.find()) {
            cids.add(cidMatcher.group(1));
        }
        if (log.isTraceEnabled() && !cids.isEmpty()) {
            log.trace("Found CIDs: {}.", (Object)cids.stream().collect(Collectors.joining(", ")));
        }
        for (String cidName : cids) {
            log.debug("Attaching '{}'.", (Object)cidName);
            int suffixStart = FilenameUtils.indexOfExtension((String)cidName);
            String resourceName = cidName.substring(0, suffixStart);
            String resourceSuffix = "." + cidName.substring(suffixStart + 1);
            Resource resource = this.resourceLoaderHelper.findLocalizedResource(resourceName, resourceSuffix, locale);
            mimeMessageHelper.addInline(cidName, resource);
        }
    }

    private String processSingleLineTextTemplate(String templateNamePrefix, Context ctx) {
        Resource resource = this.resourceLoaderHelper.findLocalizedResource(templateNamePrefix, TemplatingEngineService.templateModeToSuffix((TemplateMode)TemplateMode.TEXT), ctx.getLocale());
        String template = this.readResourceToString(resource);
        String templateProcessingResult = this.processTemplateFromContent(template, TemplateMode.TEXT, ctx);
        return StringUtils.normalizeSpace((String)templateProcessingResult);
    }

    private String processTemplateFromContent(String templateContent, TemplateMode mode, Context context) {
        String templateAndMode = mode.name() + ":" + templateContent;
        return this.templateEngine.process(templateAndMode, (IContext)context);
    }

    private static String templateModeToSuffix(TemplateMode mode) {
        return switch (1.$SwitchMap$org$thymeleaf$templatemode$TemplateMode[mode.ordinal()]) {
            case 1 -> ".html";
            case 2 -> ".txt";
            default -> {
                log.error("Mode {} is not supported for e-mail templates.", (Object)mode);
                yield "Template is invalid. Please contact your system administrator.";
            }
        };
    }

    private String readResourceToString(Resource resource) {
        String templateContent;
        try {
            templateContent = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Cannot read notification template's resource '{}'.", (Object)resource);
            templateContent = "Template is invalid. Please contact your system administrator.";
        }
        return templateContent;
    }

    private TemplateEngine createEmailTemplateEngine() {
        ThymeleafStringResolver htmlTemplateResolver = new ThymeleafStringResolver();
        htmlTemplateResolver.setOrder(Integer.valueOf(1));
        htmlTemplateResolver.setResolvablePatterns(Set.of(TemplateMode.HTML.name() + ":"));
        htmlTemplateResolver.setTemplateMode(TemplateMode.HTML);
        htmlTemplateResolver.setCacheable(false);
        htmlTemplateResolver.setName("E-mail: HTML");
        ThymeleafStringResolver textTemplateResolver = new ThymeleafStringResolver();
        textTemplateResolver.setOrder(Integer.valueOf(2));
        textTemplateResolver.setResolvablePatterns(Set.of(TemplateMode.TEXT.name() + ":"));
        textTemplateResolver.setTemplateMode(TemplateMode.TEXT);
        textTemplateResolver.setCacheable(false);
        htmlTemplateResolver.setName("E-mail: TEXT");
        this.templateEngine = new SpringTemplateEngine();
        this.templateEngine.addTemplateResolver((ITemplateResolver)htmlTemplateResolver);
        this.templateEngine.addTemplateResolver((ITemplateResolver)textTemplateResolver);
        return this.templateEngine;
    }
}

