/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_presistence;

import de.rtb.pcon.core.events.PaymentReceivedEvent;
import de.rtb.pcon.model.RecentPayment;
import de.rtb.pcon.repositories.RecentPaymentRepository;
import jakarta.transaction.Transactional;
import java.time.OffsetDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class RecentPaymentService {
    private static final Logger log = LoggerFactory.getLogger(RecentPaymentService.class);
    @Autowired
    private RecentPaymentRepository paymentQueueRepo;

    @EventListener
    void paymentRecieved(PaymentReceivedEvent event) {
        RecentPayment pqi = new RecentPayment();
        pqi.setPayment(event.getPayment());
        pqi.setReceived(event.getPayment().getServerTime());
        this.paymentQueueRepo.save((Object)pqi);
    }

    @Scheduled(cron="5 21 3 * * ?")
    @Transactional
    void evictPayentQueue() {
        Integer nrOfOdeletedPayments = this.paymentQueueRepo.trimQueue(OffsetDateTime.now().minusDays(30L));
        log.info("Deleted {} recent payments.", (Object)nrOfOdeletedPayments);
    }
}

