/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_fw;

import de.rtb.pcon.core.msg_fw.MessageForwardingDataProviderService;
import de.rtb.pcon.core.msg_fw.MessageForwardingRuleDefinition;
import de.rtb.pcon.core.notification.NotificationService;
import de.rtb.pcon.model.StatusMessage;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MessageForwardingService {
    private final MessageForwardingDataProviderService mfwDataService;
    private final NotificationService notificationService;

    public MessageForwardingService(MessageForwardingDataProviderService mfwDataService, NotificationService notificationService) {
        this.mfwDataService = mfwDataService;
        this.notificationService = notificationService;
    }

    public void fowardIfNeeded(StatusMessage m) {
        List rules = this.mfwDataService.gerAreaRuleDefinitions(m.getPdm().getZone().getArea());
        Integer statusNr = MessageForwardingService.shortToInteger((Short)m.getMessageConfig().getNumber());
        Predicate<MessageForwardingRuleDefinition> predIsActive = r -> true;
        Predicate<MessageForwardingRuleDefinition> predPdmNumber = r -> MessageForwardingService.collectionFilterAllows((Collection)r.pdmNumbers(), (Object)m.getPdm().getNumber());
        Predicate<MessageForwardingRuleDefinition> predAlertType = r -> MessageForwardingService.collectionFilterAllows((Collection)r.alertTypes(), (Object)m.getMessageConfig().getAlertType());
        Predicate<MessageForwardingRuleDefinition> predMsgNumber = r -> MessageForwardingService.collectionFilterAllows((Collection)r.messageNumbers(), (Object)statusNr);
        Predicate<MessageForwardingRuleDefinition> predTime = r -> {
            ZonedDateTime now = ZonedDateTime.now(r.userTimeZone());
            DayOfWeek dayOfWeek = now.getDayOfWeek();
            return MessageForwardingService.collectionFilterAllows((Collection)r.daysOfWeek(), (Object)dayOfWeek) && MessageForwardingService.timeInRagne((LocalTime)r.timeBegin(), (LocalTime)r.timeEnd(), (LocalTime)now.toLocalTime());
        };
        rules.stream().filter(predIsActive.and(predTime).and(predMsgNumber).and(predAlertType).and(predPdmNumber)).forEach(r -> this.notificationService.sendStatusForwarding(r, m));
    }

    static boolean timeInRagne(LocalTime start, LocalTime end, LocalTime now) {
        start = Optional.ofNullable(start).orElse(LocalTime.MIN);
        end = Optional.ofNullable(end).orElse(LocalTime.MAX);
        end = end.truncatedTo(ChronoUnit.MINUTES).plusMinutes(1L).minusNanos(1L);
        boolean dayRule = start.isBefore(end);
        boolean result = false;
        result = dayRule ? now.isAfter(start) && now.isBefore(end) : now.isBefore(end) || now.isAfter(start);
        return result;
    }

    static <T> boolean collectionFilterAllows(Collection<T> collection, T element) {
        return CollectionUtils.isEmpty(collection) || collection.contains(element);
    }

    public static final Integer shortToInteger(Short s) {
        if (s != null) {
            return (int)s;
        }
        return null;
    }
}

