/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.NestedRuntimeException;

/*
 * Exception performing whole class analysis ignored.
 */
public class PdmMessageProcessingException
extends NestedRuntimeException {
    private final Optional<Map<String, Object>> responseMap;
    private final Optional<Integer> errorCode = Optional.empty();

    public PdmMessageProcessingException(String msg) {
        super(PdmMessageProcessingException.makeErrorMessageStack((String)msg, null));
        this.responseMap = Optional.empty();
    }

    public PdmMessageProcessingException(Throwable cause) {
        super(PdmMessageProcessingException.makeErrorMessageStack((String)"Wrapped exception", (Throwable)cause));
        this.responseMap = Optional.empty();
    }

    public PdmMessageProcessingException(String msg, Throwable cause) {
        super(PdmMessageProcessingException.makeErrorMessageStack((String)msg, (Throwable)cause), cause);
        this.responseMap = Optional.empty();
    }

    public PdmMessageProcessingException(String msg, Throwable cause, Map<String, Object> responseMap) {
        super(PdmMessageProcessingException.makeErrorMessageStack((String)msg, (Throwable)cause), cause);
        this.responseMap = Optional.of(responseMap);
    }

    public Map<String, Object> getResponseMap() {
        return this.responseMap.orElseGet(() -> this.createDefaulResponseMap());
    }

    private Map<String, Object> createDefaulResponseMap() {
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        respMap.put("ERM", this.getMessage());
        this.errorCode.map(Objects::toString).ifPresent(s -> respMap.put("ERC", s));
        return respMap;
    }

    private static String makeErrorMessageStack(String title, @Nullable Throwable e) {
        LinkedList causeMessages = new LinkedList();
        if (e != null) {
            PdmMessageProcessingException.addCauseToList(causeMessages, (Throwable)e);
        }
        StringBuilder msg = new StringBuilder();
        msg.append(title + "\n");
        causeMessages.forEach(m -> msg.append(" \u2192 " + m + "\n"));
        return msg.toString();
    }

    private static void addCauseToList(List<String> list, Throwable t) {
        list.add(t.getMessage());
        if (t.getCause() != null) {
            PdmMessageProcessingException.addCauseToList(list, (Throwable)t.getCause());
        }
    }
}

