/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.core.integration.ServerResponse;
import de.rtb.pcon.core.integration.ServerResponseBinary;
import de.rtb.pcon.core.integration.ServerResponseBinaryFw5;
import de.rtb.pcon.core.integration.ServerResponseJson;
import de.rtb.pcon.core.logging.PdmThreadLocalMarker;
import de.rtb.pcon.core.services.pdm_in.MessageParserService;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/pdm"})
public class PdmMachineController {
    private static final Logger log = LoggerFactory.getLogger(PdmMachineController.class);
    private final MessageParserService msgParserService;
    private final ObjectMapper pdmJsonMapper;

    public PdmMachineController(MessageParserService msgParserService, @Qualifier(value="pdmObjectMapper") ObjectMapper pdmJsonMapper) {
        this.msgParserService = msgParserService;
        this.pdmJsonMapper = pdmJsonMapper;
    }

    @PostMapping(value={"control/dispatch-s95/json"})
    ResponseEntity<Object> dispatchSiemens95Json(@RequestBody ObjectNode jsonMsg) {
        return this.doProcess(jsonMsg);
    }

    ResponseEntity<Object> doProcess(ObjectNode mnemonics) {
        LocalDateTime enrtyTime = LocalDateTime.now();
        PdmThreadLocalMarker threadMarker = PdmThreadLocalMarker.instance();
        threadMarker.setPdm(mnemonics.path("PSA").asInt(), Optional.ofNullable(mnemonics.path("GAC")).map(JsonNode::asInt), Optional.ofNullable(mnemonics.path("PID")).map(JsonNode::asText));
        threadMarker.setNetSource("HTTP", 0);
        log.debug(">>> [HTTP]: {}", (Object)mnemonics);
        this.updateMrq(mnemonics);
        boolean isFw5Update = ObjectUtils.anyNotNull((Object[])new Object[]{mnemonics.get("FMD"), mnemonics.get("FDD"), mnemonics.get("FXD"), mnemonics.get("FML"), mnemonics.get("DLT"), mnemonics.get("FXL"), mnemonics.get("FDL")});
        String proto = isFw5Update ? "UDP" : "TCP";
        ServerResponse serverResponse = this.msgParserService.processMessage(mnemonics, proto);
        long execTime = Duration.between(enrtyTime, LocalDateTime.now()).toMillis();
        log.atInfo().setMessage("<<< [{}]: {}").addArgument(() -> PdmMachineController.formatTime((long)execTime)).addArgument(() -> ((ServerResponse)serverResponse).toString()).log();
        ServerResponse serverResponse2 = serverResponse;
        Objects.requireNonNull(serverResponse2);
        ServerResponse serverResponse3 = serverResponse2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServerResponseJson.class, ServerResponseBinary.class, ServerResponseBinaryFw5.class}, (Object)serverResponse3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ServerResponseJson json = (ServerResponseJson)serverResponse3;
                yield ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"application/json"})).body((Object)json.toJsonNode());
            }
            case 1 -> {
                ServerResponseBinary data = (ServerResponseBinary)serverResponse3;
                yield ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"application/vnd.rtb.pdm7+bin"})).body((Object)data.toBinaryMessage());
            }
            case 2 -> {
                ServerResponseBinaryFw5 data = (ServerResponseBinaryFw5)serverResponse3;
                HttpHeaders headers = new HttpHeaders();
                headers.add("Rtb-Pdm-number", Integer.toString(data.pdmNumber()));
                headers.add("Rtb-Pdm-First-Block", Integer.toString(data.firstBlock()));
                headers.add("Rtb-Pdm-Block-Size", Integer.toString(data.blockSize()));
                headers.add("Rtb-Pdm-Firmware-Type", data.firmwareType());
                headers.add("Content-Type", "application/vnd.rtb.pdm5+bin");
                yield ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)data.toBinaryMessage());
            }
        };
    }

    private static String formatTime(long timeInMs) {
        return String.format("%3d", timeInMs);
    }

    private void updateMrq(ObjectNode root) {
        if (root.get("MRQ") != null) {
            ArrayNode mrqNode = (ArrayNode)root.get("MRQ");
            if (mrqNode.size() > 0) {
                try {
                    String mrqText = this.pdmJsonMapper.writeValueAsString((Object)mrqNode);
                    root.put("MRQ", mrqText);
                }
                catch (JsonProcessingException e) {
                    log.error("Cannot replace MRQ node");
                }
            } else {
                root.remove("MRQ");
            }
        }
    }
}

