/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download.ui.plan;

import de.rtb.pcon.core.fw_download.ui.plan.FirmwareUpdateSpecifications;
import de.rtb.pcon.core.fw_download.ui.plan.UiDownloadReportEntry;
import de.rtb.pcon.core.fw_download.ui.plan.UiHwTree;
import de.rtb.pcon.core.fw_download.ui.plan.UiPlanDefinition;
import de.rtb.pcon.core.fw_download.ui.plan.UiPlanEntryState;
import de.rtb.pcon.core.fw_download.ui.plan.UiSwTree;
import de.rtb.pcon.core.fw_download.ui.plan.UiUpdatePlanEditable;
import de.rtb.pcon.core.fw_download.ui.plan.UiUpdatePlanProgress;
import de.rtb.pcon.core.hw_components.HardwarePartsMonitorService;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.download.DeviceType;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.DownloadStatus;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.model.download.SoftwareDescription;
import de.rtb.pcon.repositories.fw_update.DownloadEntryRepository;
import de.rtb.pcon.repositories.fw_update.DownloadPlanRepository;
import de.rtb.pcon.repositories.fw_update.SoftwareDescriptionRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.DateTimeUtils;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasRole('ROLE_PCON_SOFTWARE_MANAGE')")
@RequestMapping(path={"/api/pcon/ui/fw-update/plans"})
class FirmwareUpdatePlanController {
    private static final Logger log = LoggerFactory.getLogger(FirmwareUpdatePlanController.class);
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @Autowired
    private SoftwareDescriptionRepository softwareDescriptionRepo;
    @Autowired
    private DownloadPlanRepository downloadPlanRepo;
    @Autowired
    private DownloadEntryRepository dowloadEntryRepo;
    @Autowired
    private PdmRepository pdmRepo;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private I18nService i18n;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private HardwarePartsMonitorService hwMonitorSerice;

    FirmwareUpdatePlanController() {
    }

    @GetMapping
    @Transactional(readOnly=true)
    public ResponseEntity<List<UiUpdatePlanProgress>> getPlans(@RequestParam(name="area") Integer areaId, @RequestParam(name="search", required=false) String search, @RequestParam(name="hidden", defaultValue="false") boolean hidden, @RequestParam(name="page", defaultValue="1") int uiPageNr, @RequestParam(name="size", defaultValue="10") int uiPageSize) {
        Area area = this.entityLoader.loadArea(areaId.intValue());
        Specification spec = FirmwareUpdateSpecifications.hasArea((Area)area);
        spec = hidden ? spec.and(FirmwareUpdateSpecifications.isHidden()) : spec.and(FirmwareUpdateSpecifications.isVisible());
        if (StringUtils.isNotBlank((CharSequence)search)) {
            spec = spec.and(FirmwareUpdateSpecifications.containsText((String)search));
        }
        PageRequest pageRequest = PageRequest.of((int)(uiPageNr - 1), (int)uiPageSize, (Sort)Sort.by((String[])new String[]{"downloadTime"}).descending());
        Page planPage = this.downloadPlanRepo.findAll(spec, (Pageable)pageRequest);
        List allProgresses = this.downloadPlanRepo.reportProgress((Collection)planPage.getContent());
        ZoneId timeZone = this.i18n.userTimeZoneId();
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("page-total", new String[]{Integer.toString(planPage.getTotalPages())})).header("page-current", new String[]{Integer.toString(uiPageNr)})).header("page-size", new String[]{Integer.toString(uiPageSize)})).body(planPage.stream().map(dp -> new UiUpdatePlanProgress(dp, timeZone, allProgresses)).collect(Collectors.toList()));
    }

    @PutMapping
    @Transactional
    public ResponseEntity<UiPlanDefinition> putPlan(@RequestBody UiPlanDefinition uiPlan) {
        DownloadPlan plan;
        Area area = this.entityLoader.loadArea(uiPlan.getArea());
        SoftwareDescription swd = (SoftwareDescription)this.softwareDescriptionRepo.findById((Object)uiPlan.getSw().getId()).orElseThrow(() -> new EntityNotAvailableException(HttpStatus.NOT_FOUND));
        if (swd.getArea() != null) {
            this.entityLoader.checkAreaAccessForCurrentUser(swd.getArea());
        }
        List pdms = this.pdmRepo.findAllByIdAllowed((Iterable)uiPlan.getPdms());
        if (Objects.nonNull(uiPlan.getId())) {
            plan = (DownloadPlan)this.downloadPlanRepo.findByIdAndArea(uiPlan.getId().intValue(), area).orElseThrow();
        } else {
            plan = new DownloadPlan();
            plan.setEntries(List.of());
        }
        boolean hasStarted = plan.getEntries().stream().anyMatch(e -> e.getStatus() != DownloadStatus.QUEUED);
        if (hasStarted) {
            log.info("Download plan #{} has not been updated because it has already started", (Object)plan.getId());
            return ResponseEntity.status((int)210).build();
        }
        LinkedList<String> validationErrors = new LinkedList<String>();
        if (StringUtils.isBlank((CharSequence)uiPlan.getName())) {
            validationErrors.add("Name must be provided");
        }
        if (uiPlan.getActivationDate() == null) {
            validationErrors.add("Activation date must be provided");
        }
        if (uiPlan.getDownloadDate() == null || uiPlan.getDownloadTime() == null) {
            validationErrors.add("Download date time must be provided");
        }
        if (!validationErrors.isEmpty()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).header("ERROR-DESCRIPTION", new String[]{validationErrors.stream().collect(Collectors.joining(","))})).build();
        }
        ZoneId timeZone = this.i18n.userTimeZoneId();
        plan.setName(uiPlan.getName());
        plan.setArea(area);
        plan.setNote(uiPlan.getNote());
        plan.setDownloadTarget(uiPlan.getSw().getTarget());
        plan.setActivationDate(uiPlan.getActivationDate());
        plan.setDownloadTime(DateTimeUtils.toOffsetDateTime((LocalDateTime)LocalDateTime.of(uiPlan.getDownloadDate(), uiPlan.getDownloadTime()), (ZoneId)timeZone));
        plan.setEnabled(true);
        plan.setModifiedAt(OffsetDateTime.now());
        plan.setModifiedBy(this.securityService.getCurrentUser());
        plan.setSoftwareDescription(swd);
        plan.setVisible(true);
        if (CollectionUtils.isNotEmpty((Collection)plan.getEntries())) {
            List entriesToDelete = plan.getEntries();
            plan.setEntries(new LinkedList());
            this.dowloadEntryRepo.deleteAll((Iterable)entriesToDelete);
        }
        List entries = DownloadTarget.CONFIG.equals((Object)uiPlan.getSw().getTarget()) && swd.getSoftwarePaths().stream().anyMatch(p -> !"".equals(p.getPath())) ? pdms.stream().map(p -> DownloadEntry.withPath((DownloadPlan)plan, (Pdm)p)).collect(Collectors.toList()) : pdms.stream().map(p -> DownloadEntry.simple((DownloadPlan)plan, (Pdm)p)).collect(Collectors.toList());
        this.downloadPlanRepo.save((Object)plan);
        this.dowloadEntryRepo.saveAll(entries);
        plan.setEntries(entries);
        return ResponseEntity.ok((Object)new UiPlanDefinition(plan, this.i18n.userTimeZoneId()));
    }

    @GetMapping(value={"{id}"})
    @Transactional(readOnly=true)
    public UiPlanDefinition getPlan(@PathVariable(value="id") int id) {
        return new UiPlanDefinition(this.loadPlan(id), this.i18n.userTimeZoneId());
    }

    @GetMapping(value={"{id}/report"})
    @Transactional(readOnly=true)
    public List<UiDownloadReportEntry> getDownloadDistribution(@PathVariable(value="id") int id) {
        return this.loadPlan(id).getEntries().stream().map(de -> new UiDownloadReportEntry(de.getPdm().getId(), de.getStatus(), de.getId())).toList();
    }

    @PutMapping(value={"{id}/info"})
    @Transactional
    public UiUpdatePlanEditable putPlanInfo(@PathVariable(value="id") int id, @RequestBody UiUpdatePlanEditable uiData) {
        return this.patchPlanInfoResource(id, uiData, false);
    }

    @PatchMapping(value={"{id}/info"})
    @Transactional
    public UiUpdatePlanEditable patchPlanInfo(@PathVariable(value="id") int id, @RequestBody UiUpdatePlanEditable uiData) {
        return this.patchPlanInfoResource(id, uiData, true);
    }

    @DeleteMapping(value={"{id}"})
    @Transactional
    public ResponseEntity<Object> deletePlan(@PathVariable(value="id") int id) {
        DownloadPlan plan = this.loadPlan(id);
        if (this.downloadPlanRepo.canBeDeleted(plan)) {
            this.downloadPlanRepo.delete((Object)plan);
            if (actionLogger.isInfoEnabled()) {
                actionLogger.info("The {} has deleted {}).", (Object)LoggerUtils.log((User)this.securityService.getCurrentUser()), (Object)LoggerUtils.log((DownloadPlan)plan));
            }
            return ResponseEntity.ok().build();
        }
        log.warn("Update plan #{} can't be deleted because it still contains active entries.", (Object)plan.getId());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.LOCKED).build();
    }

    @PutMapping(value={"{id}/abort"})
    @Transactional
    public UiUpdatePlanProgress abortPlan(@PathVariable(value="id") int id) {
        DownloadPlan plan = this.loadPlan(id);
        this.downloadPlanRepo.abortPlan(plan);
        if (actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} has aborted {}).", (Object)LoggerUtils.log((User)this.securityService.getCurrentUser()), (Object)LoggerUtils.log((DownloadPlan)plan));
        }
        return new UiUpdatePlanProgress(plan, this.i18n.userTimeZoneId());
    }

    @PutMapping(value={"{id}/retry"})
    @Transactional
    public UiUpdatePlanProgress retryPlan(@PathVariable(value="id") int id) {
        DownloadPlan plan = this.loadPlan(id);
        this.downloadPlanRepo.retryPlan(plan);
        if (actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} has restarted {}).", (Object)LoggerUtils.log((User)this.securityService.getCurrentUser()), (Object)LoggerUtils.log((DownloadPlan)plan));
        }
        return new UiUpdatePlanProgress(plan, this.i18n.userTimeZoneId());
    }

    @PutMapping(value={"entries"})
    @Transactional
    public void deletePlanEntry(@RequestBody UiPlanEntryState uiState) {
        this.dowloadEntryRepo.findById((Object)uiState.entryId()).filter(en -> this.securityService.hasRightFor(en.getPdm())).ifPresent(en -> {
            DownloadStatus oldState = en.getStatus();
            en.setStatus(uiState.state());
            if (actionLogger.isInfoEnabled()) {
                actionLogger.info("{} changed state of download plan entry '{}' in plan '{}' , {} -> {} .", new Object[]{StringUtils.capitalize((String)LoggerUtils.log((User)this.securityService.getCurrentUser())), uiState.entryId(), en.getPlan().getName(), oldState, uiState.state()});
            }
        });
    }

    @GetMapping(value={"sw-tree/{id}"})
    @Transactional(readOnly=true)
    public List<UiSwTree> swTree(@PathVariable(value="id") int areaId) {
        Area area = this.entityLoader.loadArea(areaId);
        Map<DeviceType, List<SoftwareDescription>> deviceMap = this.softwareDescriptionRepo.loadForSwTree(area).stream().collect(Collectors.groupingBy(SoftwareDescription::getDeviceType));
        return deviceMap.entrySet().stream().map(e -> new UiSwTree((DeviceType)e.getKey(), (List)e.getValue(), area)).collect(Collectors.toList());
    }

    @GetMapping(value={"hw-tree/{id}"})
    @Transactional(readOnly=true)
    public List<UiHwTree> hwTree(@PathVariable(value="id") int areaId) {
        Area area = this.entityLoader.loadArea(areaId);
        Map hwMap = this.hwMonitorSerice.fetchUpgradableComponents(area);
        return hwMap.entrySet().stream().map(UiHwTree::new).collect(Collectors.toList());
    }

    private UiUpdatePlanEditable patchPlanInfoResource(int id, UiUpdatePlanEditable props, boolean patch) {
        String diff;
        DownloadPlan plan = this.loadPlan(id);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        UiUpdatePlanEditable diffBase = new UiUpdatePlanEditable(plan, timeZone);
        if (!patch || props.getName() != null) {
            plan.setName(props.getName());
        }
        if (props.getVisible() != null) {
            plan.setVisible(props.getVisible().booleanValue());
        }
        if (props.getEnabled() != null) {
            plan.setEnabled(props.getEnabled().booleanValue());
        }
        if (props.getStartsAt() != null) {
            plan.setDownloadTime(DateTimeUtils.toOffsetDateTime((LocalDateTime)props.getStartsAt(), (ZoneId)timeZone));
        }
        if (actionLogger.isInfoEnabled() && StringUtils.isNotBlank((CharSequence)(diff = LoggerUtils.makeObjectDiff((Object)new UiUpdatePlanEditable(plan, timeZone), (Object)diffBase)))) {
            this.securityService.getCurrentUser();
            actionLogger.info("User {} has changed properties of {}; {}", new Object[]{LoggerUtils.log((User)this.securityService.getCurrentUser()), LoggerUtils.log((DownloadPlan)plan), diff});
        }
        return new UiUpdatePlanEditable(plan, timeZone);
    }

    private DownloadPlan loadPlan(int id) {
        DownloadPlan plan = (DownloadPlan)this.downloadPlanRepo.findById((Object)id).orElseThrow(() -> new EntityNotAvailableException(HttpStatus.NOT_FOUND));
        this.entityLoader.checkAreaAccessForCurrentUser(plan.getArea());
        return plan;
    }
}

