/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download;

import de.rtb.pcon.core.fw_download.FirmwareDownloadService;
import de.rtb.pcon.core.fw_download.FirmwareDownloadServiceIp;
import de.rtb.pcon.core.integration.ServerResponseJson;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.core.services.pdm_in.SoftwareDataProvider;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadStatus;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.repositories.fw_update.DownloadEntryRepository;
import jakarta.persistence.NonUniqueResultException;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.IntegerValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class FirmwareDownloadServiceIp
implements FirmwareDownloadService {
    private static final Logger logger = LoggerFactory.getLogger(FirmwareDownloadServiceIp.class);
    protected String wanIpAdressHex;
    protected String wanPortHex;
    @Autowired
    private SoftwareDataProvider swDataProvider;
    @Autowired
    private DownloadEntryRepository downloadEntryRepo;
    public static final DateTimeFormatter DGA_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");

    protected FirmwareDownloadServiceIp(String wanIp, Integer wanPort) {
        this.setWanIpAddress(wanIp);
        this.setWanPort(wanPort);
    }

    @Transactional
    public void checkDownload(Pdm pdm, ServerResponseJson response) {
        List availableDownloadList = this.downloadEntryRepo.availableDownloads(pdm);
        response.append("UEZ90000");
        if (!availableDownloadList.isEmpty()) {
            if (this.wanIpAdressHex == null || this.wanPortHex == null) {
                logger.error("Service is not initialized. Either pcon.wan.ip address or wan.port is not set correctly. Download aborted.");
            } else {
                DownloadEntry fwDownload = (DownloadEntry)availableDownloadList.get(0);
                response.append("REQ");
                response.append("IPN", (Object)this.wanIpAdressHex);
                response.append("PRT", (Object)StringUtils.leftPad((String)this.wanPortHex, (int)4, (String)"0"));
                String wiw = String.format("%04X", fwDownload.getPlan().getDownloadTarget().deviceType().getWiw());
                response.append("WIW", (Object)wiw);
                response.append("VER", (Object)"419");
            }
        }
    }

    protected Optional<DownloadEntry> getFirmwareDescription(Pdm pdm, DownloadTarget target) {
        Optional nextDownloadEntry = this.downloadEntryRepo.nextAvailableDownloadForTarget(pdm, target);
        nextDownloadEntry.ifPresent(de -> this.markOverwrittenDownloads(pdm, target));
        return nextDownloadEntry;
    }

    protected void markOverwrittenDownloads(Pdm pdm, DownloadTarget target) {
        Set<DownloadTarget> affectedTargets = null;
        switch (1.$SwitchMap$de$rtb$pcon$model$download$DownloadTarget[target.ordinal()]) {
            case 1: 
            case 2: {
                affectedTargets = Set.of(DownloadTarget.CARD_READER_1, DownloadTarget.CARD_READER_2);
                break;
            }
            case 3: 
            case 4: {
                affectedTargets = Set.of(DownloadTarget.PRINTER_1, DownloadTarget.PRINTER_2);
                break;
            }
            default: {
                affectedTargets = Set.of(target);
            }
        }
        this.downloadEntryRepo.transferedForTargets(pdm, affectedTargets).forEach(downloadEntry -> {
            downloadEntry.setStatus(DownloadStatus.OVERWRITTEN);
            logger.info("Download transfered on {}@{} for {} on {} was overwritten.", new Object[]{pdm.getNumber(), pdm.getZone().getArea().getId(), target, downloadEntry.getDownloadConfirmation()});
        });
    }

    protected byte[] getFilePartData(Pdm pdm, DownloadTarget target, int startOffset, int length, String path) {
        try {
            Optional fwDownloadO = this.downloadEntryRepo.findByPdmAndTargetAndStatus(pdm, target, DownloadStatus.IN_PROGRESS);
            if (fwDownloadO.isEmpty()) {
                logger.error("Requested download item doesn't exist.");
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            DownloadEntry fwDownload = (DownloadEntry)fwDownloadO.get();
            byte[] result = this.swDataProvider.getSoftwareDataArray(fwDownload.getPlan().getSoftwareDescription(), path, startOffset, length);
            return result;
        }
        catch (IllegalStateException e) {
            logger.error("Cannot read file to download from database", (Throwable)e);
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        catch (NonUniqueResultException e) {
            logger.error("There is multiple downloads of requested type.");
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
    }

    @Transactional
    public void updateTransferStatus(PdmMessageDto m, DownloadTarget dt) {
        DownloadStatus dsOld = null;
        DownloadStatus dsNew = null;
        switch (m.getMnr()) {
            case 91: 
            case 124: 
            case 158: {
                dsOld = DownloadStatus.IN_PROGRESS;
                dsNew = DownloadStatus.ACTIVATED;
                break;
            }
            case 112: 
            case 113: 
            case 225: {
                dsOld = DownloadStatus.IN_PROGRESS;
                dsNew = DownloadStatus.TRANSFERRED;
                break;
            }
            case 114: 
            case 226: {
                dsOld = DownloadStatus.TRANSFERRED;
                dsNew = DownloadStatus.ACTIVATED;
                break;
            }
            case 159: {
                dt = DownloadTarget.MODEM;
                dsOld = DownloadStatus.TRANSFERRED;
                dsNew = DownloadStatus.ACTIVATED;
                break;
            }
            case 256: {
                dsOld = DownloadStatus.IN_PROGRESS;
                dsNew = DownloadStatus.TRANSFER_FAILED;
                break;
            }
            case 258: {
                dsOld = DownloadStatus.TRANSFERRED;
                dsNew = DownloadStatus.ACTIVATION_FAILED;
                break;
            }
            default: {
                return;
            }
        }
        try {
            Optional confirmedDownloadO = this.downloadEntryRepo.findByPdmAndTargetAndStatus(m.getPdm(), dt, dsOld);
            if (confirmedDownloadO.isEmpty()) {
                logger.warn("Download item to confirm doesn't exist.");
                return;
            }
            DownloadEntry confirmedDownload = (DownloadEntry)confirmedDownloadO.get();
            switch (1.$SwitchMap$de$rtb$pcon$model$download$DownloadStatus[dsNew.ordinal()]) {
                case 1: {
                    confirmedDownload.setDownloadConfirmation(m.getDatTim());
                    logger.info("File '{}' from download plan '{}' successfully downloaded.", (Object)confirmedDownload.getPlan().getSoftwareDescription().getFileName(), (Object)confirmedDownload.getPlan().getName());
                    break;
                }
                case 2: {
                    confirmedDownload.setDownloadConfirmation(m.getDatTim());
                    logger.info("File '{}' from download plan '{}' failed to download.", (Object)confirmedDownload.getPlan().getSoftwareDescription().getFileName(), (Object)confirmedDownload.getPlan().getName());
                    break;
                }
                case 3: {
                    confirmedDownload.setActivationConfirmation(m.getDatTim());
                    logger.info("File '{}' from download plan '{}' successfully activated.", (Object)confirmedDownload.getPlan().getSoftwareDescription().getFileName(), (Object)confirmedDownload.getPlan().getName());
                    break;
                }
                case 4: {
                    confirmedDownload.setActivationConfirmation(m.getDatTim());
                    logger.info("File '{}' from download plan '{}' failed to activate.", (Object)confirmedDownload.getPlan().getSoftwareDescription().getFileName(), (Object)confirmedDownload.getPlan().getName());
                    break;
                }
                default: {
                    throw new IllegalStateException("Download status '" + dsNew.toString() + "' can not be used as confirmation.");
                }
            }
            confirmedDownload.setStatus(dsNew);
        }
        catch (NonUniqueResultException e) {
            logger.error("There is multiple results for download {}, {}. It usually means data consistency error. Message is ignored.", (Object)dt, (Object)dsOld);
        }
    }

    public String getWanPortHex() {
        return StringUtils.leftPad((String)this.wanPortHex, (int)4, (String)"0");
    }

    public String getWanIpHex() {
        return this.wanIpAdressHex;
    }

    private void setWanIpAddress(String ipAddressStr) {
        if (InetAddressValidator.getInstance().isValidInet4Address(ipAddressStr)) {
            Object[] ipStrParts = StringUtils.split((String)ipAddressStr, (char)'.');
            ArrayUtils.reverse((Object[])ipStrParts);
            StringBuilder hexIpAddress = new StringBuilder();
            for (Object s : ipStrParts) {
                String ipHexPart = StringUtils.leftPad((String)Integer.toHexString(Integer.parseInt((String)s)), (int)2, (char)'0');
                hexIpAddress.append(ipHexPart);
            }
            this.wanIpAdressHex = hexIpAddress.toString().toUpperCase();
        } else {
            logger.error("Invalid IP address of wan interface '{}'. Please check application configuration: 'pcon.wan.ip'. The firmware update will not work. ", (Object)ipAddressStr);
        }
    }

    private void setWanPort(Integer port) {
        if (port != null && IntegerValidator.getInstance().isInRange(port, 0, 65535)) {
            this.wanPortHex = Integer.toHexString(port).toUpperCase();
        } else {
            String className = this.getClass().getName();
            int lastCapitalLetter = 0;
            for (int i = className.length() - 1; i >= 0; --i) {
                if (!Character.isUpperCase(className.charAt(i))) continue;
                lastCapitalLetter = i;
                break;
            }
            String protocolName = className.substring(lastCapitalLetter).toLowerCase();
            logger.error("Invalid IP port of wan interface '{}'. Please check application configuration: wan.{}Port. The firmware update will not work.", (Object)port, (Object)protocolName);
        }
    }
}

