/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.aims;

import com.google.common.collect.Sets;
import de.rtb.pcon.api.enforcement.aims.AimsPermit;
import de.rtb.pcon.api.enforcement.aims.AimsPermits;
import de.rtb.pcon.api.enforcement.aims.AimsScope;
import de.rtb.pcon.api.enforcement.aims.AimsScopes;
import de.rtb.pcon.api.enforcement.aims.service.EnfPermit;
import de.rtb.pcon.api.enforcement.aims.service.EnfZone;
import de.rtb.pcon.api.enforcement.aims.service.EnforcementService;
import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="AIMS 2", description="Integration with AIMS. End points have <code>xml</code> in their names from historical reasons. Nevertheless they support both JSON and XML format.")
@RestController
@RequestMapping(value={"/api/enforcement/aims2/"})
@PreAuthorize(value="hasRole('ROLE_ENFORCEMENT_VIEW')")
public class AimsEnforcementController2 {
    @Autowired
    private EnforcementService enfService;

    @Operation(summary="List all zones available for enforcement for the client")
    @GetMapping(value={"scopes.xml"})
    @Transactional(readOnly=true)
    public ResponseEntity<AimsScopes> scopes(@Parameter(description="Area (town) which should be considered.") @RequestParam(value="client", required=true) int parAreaId) {
        Set enfZones = this.enfService.listZones(parAreaId);
        Set aimScopes = enfZones.stream().map(AimsScope::new).collect(Collectors.toSet());
        return new ResponseEntity((Object)new AimsScopes(aimScopes), (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Find all valid plates in the specific zone at the specific time.", description="It should be used to get an overview which license plates are available in Zone. Also it can be used to process information offline by additional tools. ")
    @GetMapping(value={"validLicensePlates.xml"})
    @Transactional(readOnly=true)
    public ResponseEntity<AimsPermits> validLicensePlates(@Parameter(description="Area (town) which should be considered.") @RequestParam(value="client", required=true) Integer parAreaId, @Parameter(description="IDs of parking zones to consider. Zones *must* belong Area defined in parameter <code>area</code>.") @RequestParam(value="scope", required=true) Set<Integer> parZones, @Parameter(description="Time used for verification. If not provided now is used. This parameter is currently not used. It is there for compatibility reasons.") @RequestParam(value="time", required=false) String parTime, @Parameter(description="Name of client time zone. If not provided UTC is used.") @RequestParam(value="timeZone", defaultValue="UTC") String parTimeZone, @Parameter(description="Extends validity of parking ticket about provided number of minutes.") @RequestParam(value="gracePeriod", defaultValue="0") int parGracePeriod) {
        List validZoneIds = this.enfService.verifyZoneIdsLoosly(parAreaId, parZones);
        Set permits = this.enfService.validPermits((Collection)validZoneIds, Collections.emptySet(), Duration.ofMinutes(parGracePeriod));
        Set validPermits = permits.stream().map(AimsPermit::new).collect(Collectors.toSet());
        if (validZoneIds.size() == parZones.size()) {
            return new ResponseEntity((Object)new AimsPermits(validPermits), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)new AimsPermits(validPermits), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
    }

    @Operation(summary="Validate whether provided license plate is valid in any parking zone belonging to Area.")
    @GetMapping(value={"validateLicensePlates.xml"})
    @Transactional(readOnly=true)
    public ResponseEntity<AimsPermits> validateLicensePlates(@Parameter(description="Area (town) which should be considered.") @RequestParam(value="client", required=true) Integer parAreaId, @Parameter(description="Collection of license plate numbers to verify.") @RequestParam(value="licensePlate", required=true) Set<String> parLicensePlates, @Parameter(description="IDs of parking zones to consider. Zones *must* belong Area defined in parameter <code>area</code>.") @RequestParam(value="scope", required=false) Set<Integer> parScopes, @Parameter(description="Time used for verification. If not provided now is used. This parameter is currently not used. It is there for compatibility reasons.") @RequestParam(value="time", required=false) String parTime, @Parameter(description="name of client time zone. If not provided UTC is used.") @RequestParam(value="timeZone", required=false, defaultValue="UTC") String parTimeZone, @Parameter(description="extends validity of parking ticket about provided number of minutes.") @RequestParam(value="gracePeriod", defaultValue="0") int parGracePeriod) {
        if (parScopes == null) {
            parScopes = this.enfService.listZones(parAreaId.intValue()).stream().map(EnfZone::getId).collect(Collectors.toSet());
        }
        List validZoneIds = this.enfService.verifyZoneIdsLoosly(parAreaId, parScopes);
        Set permits = this.enfService.validPermits((Collection)validZoneIds, parLicensePlates, Duration.ofMinutes(parGracePeriod));
        ArrayList result = new ArrayList(parLicensePlates.size());
        result.addAll(permits.stream().map(p -> new AimsPermit(p, true)).collect(Collectors.toSet()));
        Set foundPlates = permits.stream().map(EnfPermit::getLicensePlate).collect(Collectors.toSet());
        Sets.difference(parLicensePlates, foundPlates).stream().forEach(l -> {
            Optional<EnfPermit> oPermit = permits.stream().filter(p -> p.getLicensePlate().equals(MessageParserHelper.parseLcn((String)l))).sorted((p1, p2) -> p2.getValidTo().compareTo(p1.getValidTo())).findFirst();
            if (oPermit.isPresent()) {
                AimsPermit a = new AimsPermit(oPermit.get(), true);
                a.setLicenseNumber(l);
                result.add(a);
            } else {
                AimsPermit a = new AimsPermit();
                a.setValid(Boolean.valueOf(false));
                a.setLicenseNumber(l);
                result.add(a);
            }
        });
        if (validZoneIds.size() == parScopes.size()) {
            return new ResponseEntity((Object)new AimsPermits(result), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)new AimsPermits(result), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
    }
}

