--liquibase formatted sql
--changeset ales.holec:251122T1414 stripComments:false splitStatements:false

ALTER TABLE IF EXISTS control.message_config_default ADD COLUMN mcd_essential boolean NOT NULL DEFAULT False;
COMMENT ON COLUMN control.message_config_default.mcd_essential IS 'This is advanced diagnostic message defined by Hermann which should not be shown to ordinary user.';
COMMENT ON COLUMN control.message_config_default.mcd_important IS 'Messages defined by Hermann as important. Those must be visible in message forwarding even if they was not received from PDM yet.';

UPDATE control.message_config_default SET mcd_essential = True WHERE mcd_number in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,17,18,19,20,21,22,24,25,26,27,28,29,30,31,32,33,36,39,40,41,42,43,44,45,46,47,48,49,50,51,52,55,56,57,58,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,94,95,96,102,103,104,105,106,107,130,131,146,200,201,202,203,204,205);


-- Recreate function used for adding new status messag definitions
DROP FUNCTION IF EXISTS control.add_default_message_config(integer, integer, control.status_message_alert, control.status_message_impact, boolean, boolean);

CREATE OR REPLACE FUNCTION control.add_default_message_config(
	in_msg_nr integer,
	in_solve_nr integer,
	in_alert_type control.status_message_alert,
	in_msg_impact control.status_message_impact,
	in_manual boolean DEFAULT false,
	in_important boolean DEFAULT false,
	in_essential boolean DEFAULT false)
    RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
AS $BODY$
DECLARE
BEGIN
	-- Sanity checks
	IF in_msg_impact = 'NEGATIVE' AND in_solve_nr IS NULL THEN RAISE EXCEPTION 'Negative message has to define solve number.'; END IF;
	IF in_msg_impact IN ('POSITIVE', 'TRANSIENT') AND in_solve_nr IS NOT NULL THEN RAISE EXCEPTION 'Positive and transient message must not define solve number.'; END IF;
	IF in_manual IS NULL THEN RAISE EXCEPTION 'Manual mode must not be null'; END IF;
	IF in_important IS NULL THEN RAISE EXCEPTION 'Important mode must not be null'; END IF;
	IF in_msg_impact = 'POSITIVE' AND in_alert_type != 'NONE' IS NULL THEN RAISE EXCEPTION 'Alert type for positive messages has to be NONE'; END IF;

	-- Test solve message properties
	IF in_solve_nr IS NOT NULL
	THEN
		-- Test if referenced message exists
		IF (SELECT COUNT(*) FROM control.message_config_default WHERE mcd_number = in_solve_nr) = 0 THEN RAISE EXCEPTION 'Referenced positive message % does not exits.', in_solve_nr; END IF;
		-- Test if referenced message is really positive
		IF (SELECT mcd_impact FROM control.message_config_default WHERE mcd_number = in_solve_nr) != 'POSITIVE' THEN RAISE EXCEPTION 'Referenced positive message % is not positive.', in_solve_nr; END IF;
	END IF;

	INSERT INTO control.message_config_default(mcd_number, mcd_solve, mcd_alert, mcd_impact, mcd_manual, mcd_important, mcd_essential)
	VALUES (in_msg_nr, in_solve_nr, in_alert_type, in_msg_impact, in_manual, in_important, in_essential)
	ON CONFLICT (mcd_number)
	DO UPDATE SET mcd_solve = in_solve_nr, mcd_alert = in_alert_type, mcd_impact = in_msg_impact, mcd_manual = in_manual, mcd_important = in_important, mcd_essential = in_essential;
END;
$BODY$;


