/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.ui.controllers.reports.payments.SalesByPdmDto;
import jakarta.persistence.QueryHint;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Param;

public interface PaymentReportRepository
extends Repository<PaymentTransaction, PaymentTransactionId> {
    @QueryHints(value={@QueryHint(name="org.hibernate.fetchSize", value="10000")})
    @Query(value="FROM #{#entityName} p\nwhere\n       p.id.pdm IN (:pdms)\n   AND p.paymentReason IN (:reasons)\n   AND p.paymentType   IN (:types)\n   AND p.id.pdmTime >= :from\n   AND p.id.pdmTime < :to")
    public Stream<PaymentTransaction> streamPaymentsForAmountReport(@Param(value="pdms") Collection<Pdm> var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3, @Param(value="reasons") Collection<PaymentReason> var4, @Param(value="types") Collection<PaymentType> var5);

    @QueryHints(value={@QueryHint(name="org.hibernate.fetchSize", value="10000")})
    @Query(value="FROM #{#entityName} p\nwhere\n       p.id.pdm IN (:pdms)\n   AND p.paymentReason IN (:reasons)\n   AND p.paymentType   IN (:types)\n   AND p.id.pdmTime >= :from\n   AND p.id.pdmTime < :to\n   AND p.parkEndTime IS NOT NULL")
    public Stream<PaymentTransaction> streamPaymentsForDurationReport(@Param(value="pdms") Collection<Pdm> var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3, @Param(value="reasons") Collection<PaymentReason> var4, @Param(value="types") Collection<PaymentType> var5);

    @Query(value="SELECT\nEXTRACT(YEAR FROM p.id.pdmTime) AS calYear,\nEXTRACT(WEEK FROM p.id.pdmTime) AS calWeek,\nEXTRACT(HOUR FROM p.id.pdmTime) AS calHour,\np.id.pdm.id AS pdmId,\nCOUNT (*) AS ticCount\nFROM #{#entityName} p\nWHERE\np.id.pdm IN (:pdms)\nAND\np.id.pdmTime >= :from\nAND\np.id.pdmTime < :to\nAND\np.paymentReason = :prPurchase\nGROUP BY EXTRACT(YEAR FROM p.id.pdmTime), EXTRACT(WEEK FROM p.id.pdmTime), EXTRACT(HOUR FROM p.id.pdmTime), p.id.pdm\nORDER BY EXTRACT(YEAR FROM p.id.pdmTime), EXTRACT(WEEK FROM p.id.pdmTime), EXTRACT(HOUR FROM p.id.pdmTime), p.id.pdm")
    public List<SalesByPdmDto> ticketSalePerPdm(@Param(value="pdms") Collection<Pdm> var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3, @Param(value="prPurchase") PaymentReason var4);
}

