/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.core.look_up.LookupDbService;
import de.rtb.pcon.core.look_up.payment_filters.PaymentFilterLookupDto;
import de.rtb.pcon.core.look_up.status_filters.StatusFilterLookupDto;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.MessageConfigUser;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.repositories.MessageConfigDefaultRepository;
import de.rtb.pcon.repositories.MessageConfigUserRepository;
import de.rtb.pcon.repositories.TariffInfoRepository;
import de.rtb.pcon.repositories.ZoneRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.model.UiArea;
import de.rtb.pcon.ui.controllers.model.UiPaymentFilters;
import de.rtb.pcon.ui.controllers.model.UiPdm;
import de.rtb.pcon.ui.controllers.model.UiPdmGeo;
import de.rtb.pcon.ui.controllers.model.UiProject;
import de.rtb.pcon.ui.controllers.model.UiStausConfig2;
import de.rtb.pcon.ui.controllers.model.UiTariffInfo;
import de.rtb.pcon.ui.controllers.model.UiZone;
import de.rtb.pcon.ui.controllers.model.UiZone2;
import de.rtb.pcon.ui.controllers.model.filter.FilterPdmInclusive;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/"})
public class BasicObjectColroller {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private PdmFilterRepository pdmFilterRepo;
    @Autowired
    private TariffInfoRepository tariffInfoRepo;
    @Autowired
    private MessageConfigDefaultRepository statusConfigDefaultRepo;
    @Autowired
    private MessageConfigUserRepository statusConfigUserRepo;
    @Autowired
    private ZoneRepository zoneRepo;
    @Autowired
    private PdmRepository pdmRepo;
    @Autowired
    private LookupDbService dbLookupService;

    @GetMapping(value={"project/filter/pdms"})
    @Transactional(readOnly=true)
    public UiProject getFilterProject() {
        UiProject result = new UiProject();
        List areas = this.securityService.getCurrentAreas();
        result.setAreas((Collection)areas.stream().map(UiArea::new).collect(Collectors.toSet()));
        result.setZones((Collection)this.zoneRepo.findByAreaIn((Collection)areas).stream().map(UiZone2::new).collect(Collectors.toSet()));
        result.setPdms((Collection)this.pdmRepo.findByArea((Collection)areas).stream().map(UiPdm::new).collect(Collectors.toSet()));
        return result;
    }

    @GetMapping(value={"project/filter/payments"})
    @Transactional(readOnly=false)
    public List<UiPaymentFilters> getFilterPayments() {
        List areas = this.securityService.getCurrentAreas();
        List dbLookups = this.dbLookupService.findPaymentFilters((Collection)areas);
        Set uniqueTariffsIds = dbLookups.stream().flatMap(l -> l.getTariffIds().stream()).collect(Collectors.toSet());
        List allTariffInfos = StreamSupport.stream(this.tariffInfoRepo.findAllById(uniqueTariffsIds).spliterator(), false).collect(Collectors.toList());
        return areas.stream().map(a -> {
            UiPaymentFilters areaFilters = new UiPaymentFilters();
            PaymentFilterLookupDto dbLookup = dbLookups.stream().filter(l -> l.getArea().equals(a.getId())).findFirst().orElseGet(() -> new PaymentFilterLookupDto(a.getId().intValue()));
            areaFilters.setArea(dbLookup.getArea().intValue());
            areaFilters.setReasons((Collection)dbLookup.getPaymentReasons());
            areaFilters.setTypes((Collection)dbLookup.getPaymentTypes());
            boolean hasNullTariff = dbLookup.getTariffIds().contains(null);
            Set tariffInfos = allTariffInfos.stream().filter(ti -> dbLookup.getTariffIds().contains(ti.getId())).collect(Collectors.toSet());
            areaFilters.setTariffInfos((Collection)tariffInfos.stream().map(UiTariffInfo::new).collect(Collectors.toSet()));
            if (hasNullTariff) {
                areaFilters.getTariffInfos().add(new UiTariffInfo(null));
            }
            return areaFilters;
        }).toList();
    }

    @GetMapping(value={"project/filter/status/used"})
    @Transactional(readOnly=false)
    public Collection<UiStausConfig2> getStatusConfig(Authentication authentication) {
        boolean showAllStatusMessages = UserRole.containsRole((Authentication)authentication, (UserRole)UserRole.ROLE_PCON_SUPPORT);
        List areas = this.securityService.getCurrentAreas();
        this.statusConfigDefaultRepo.findAll();
        Map<Integer, List<MessageConfigUser>> userConfigMap = this.statusConfigUserRepo.findByAreaIn((Collection)areas).stream().collect(Collectors.groupingBy(v -> v.getArea().getId()));
        List dbLookupUsedMsgs = this.dbLookupService.findStatusFilters((Collection)areas, showAllStatusMessages);
        HashMap<Short, UiStausConfig2> result = new HashMap<Short, UiStausConfig2>();
        for (StatusFilterLookupDto areaAndSmNumbers : dbLookupUsedMsgs) {
            List userMsgs = userConfigMap.getOrDefault(areaAndSmNumbers.getArea(), List.of());
            for (Short smNr : areaAndSmNumbers.getStatuses()) {
                Optional<UiStausConfig2> oUiSm = Optional.ofNullable((UiStausConfig2)result.get(smNr)).or(() -> this.statusConfigDefaultRepo.findById((Object)smNr).map(UiStausConfig2::new));
                if (!oUiSm.isPresent()) continue;
                result.put(smNr, oUiSm.get());
                Boolean isManual = userMsgs.stream().filter(um -> smNr.equals(um.getNumber())).findAny().map(MessageConfigUser::isManual).orElse(oUiSm.get().isManual());
                oUiSm.get().getAreas().add(new UiStausConfig2.AreaConfig(areaAndSmNumbers.getArea().intValue(), isManual.booleanValue()));
            }
        }
        return result.values();
    }

    @GetMapping(value={"project/filter/status/all"})
    public Collection<UiStausConfig2> getStatusConfig2(Authentication authentication) {
        boolean showAllStatusMessages = UserRole.containsRole((Authentication)authentication, (UserRole)UserRole.ROLE_PCON_SUPPORT);
        Iterable allStatusConfig = showAllStatusMessages ? this.statusConfigDefaultRepo.findAll() : this.statusConfigDefaultRepo.findByEssentialTrue();
        return StreamSupport.stream(allStatusConfig.spliterator(), false).map(UiStausConfig2::new).toList();
    }

    @GetMapping(value={"areas/zones"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<Map<String, Object>> getZoneTree() {
        List allowedAreas = this.securityService.getCurrentAreas();
        LinkedList<Map<String, Object>> uiResult = new LinkedList<Map<String, Object>>();
        for (Area a : allowedAreas) {
            HashMap<String, Object> uiResultItem = new HashMap<String, Object>();
            uiResultItem.put("area", new UiArea(a));
            uiResultItem.put("zones", a.getZones().stream().map(z -> new UiZone(z, true)).collect(Collectors.toSet()));
            uiResult.add(uiResultItem);
        }
        return uiResult;
    }

    @GetMapping(value={"pdms"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<UiPdm> getPdmsFiltered(@RequestParam(name="area", required=false) Set<Integer> uiAreaIds, @RequestParam(name="zone", required=false) Set<Integer> uiZoneIds, @RequestParam(name="pdm", required=false) Set<Integer> uiPdmIds) {
        FilterPdmInclusive pdmFilter = new FilterPdmInclusive(uiAreaIds, uiZoneIds, uiPdmIds);
        List pdms = this.pdmFilterRepo.findPdmsByInclusiveFilter(pdmFilter);
        if (pdms.isEmpty()) {
            return List.of();
        }
        return this.entityManager.createQuery("from Pdm p where p in (:pdms)", Pdm.class).setParameter("pdms", (Object)pdms).getResultStream().map(UiPdm::new).toList();
    }

    @GetMapping(value={"pdms/geo"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<UiPdmGeo> getPdmsGeoFiltered(@RequestParam(name="area", required=false) Set<Integer> uiAreaIds, @RequestParam(name="zone", required=false) Set<Integer> uiZoneIds, @RequestParam(name="pdm", required=false) Set<Integer> uiPdmIds) {
        FilterPdmInclusive pdmFilter = new FilterPdmInclusive(uiAreaIds, uiZoneIds, uiPdmIds);
        List pdms = this.pdmFilterRepo.findPdmsByInclusiveFilter(pdmFilter);
        if (pdms.isEmpty()) {
            return List.of();
        }
        return this.entityManager.createQuery("FROM Pdm p JOIN FETCH p.zone WHERE p in (:pdms)", Pdm.class).setParameter("pdms", (Object)pdms).getResultStream().map(UiPdmGeo::new).toList();
    }
}

