/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoPdmConfirmSaleRequest;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.model.Pdm;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrConfirmSale
implements RealTimeRequest {
    private final RestClient restClient;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    RaoRtrConfirmSale(@Qualifier(value="wc3rdPartyApi") RestClient restClient, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 56;
    }

    public String getDescription() {
        return "RAO, confirm sale";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Pdm pdm = ctx.global().getPdm();
        RaoConfigDto config = (RaoConfigDto)this.raoConfigService.fetchConfig(pdm.getZone().getArea());
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        RaoPdmConfirmSaleRequest confirmSaleRequest = (RaoPdmConfirmSaleRequest)ctx.getLocalObject("body", RaoPdmConfirmSaleRequest.class);
        RaoPdmConfirmSaleRequest confirmSaleRequestWithPdm = confirmSaleRequest.addPdm(pdm);
        try {
            URI uri = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"api", "rao", "sale", "confirm"}).build().toUri();
            Object confirmSateResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri(uri)).body((Object)confirmSaleRequestWithPdm).retrieve().body(Object.class);
            return Map.of("httpStatus", 200, "body", confirmSateResponse);
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            return Map.of("ERC", 3, "ERM", "Cannot access Applejack API.");
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

