/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrAbortSale
implements RealTimeRequest {
    private final RestClient restClient;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    public RaoRtrAbortSale(@Qualifier(value="wc3rdPartyApi") RestClient restClient, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 57;
    }

    public String getDescription() {
        return "RAO, abort sale";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto config = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        Object iniSaleRequest = ctx.getLocalObject("body", Object.class);
        try {
            URI uri = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"api", "rao", "sale", "abort"}).build().toUri();
            Object confirmSateResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri(uri)).body(iniSaleRequest).retrieve().body(Object.class);
            return Map.of("httpStatus", 200, "body", confirmSateResponse);
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

