/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.hks;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.hks.HksConfigDto;
import de.rtb.pcon.features.partners.hks.HksConfigService;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/hks/"})
class HksController {
    @Autowired
    private HksConfigService cfgService;
    @Autowired
    private SecureEntityLoaderService entityLoader;

    HksController() {
    }

    @GetMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional(readOnly=true)
    public HksConfigDto getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        return (HksConfigDto)this.cfgService.fetchConfig(area);
    }

    @PostMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional
    public void setConfig(@PathVariable int id, @RequestBody HksConfigDto config) {
        HksConfigDto validatedConfig = new HksConfigDto(config.enabled(), StringUtils.removeEnd((String)config.baseUrl(), (String)"/"), config.user(), config.password());
        Area area = this.entityLoader.loadArea(id);
        this.cfgService.updateConfig(area, (PartnerConfiguration)validatedConfig);
    }
}

