/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.basic_2;

import de.rtb.pcon.features.bonus.basic_2.BonBasic2ConfigEntity;
import de.rtb.pcon.features.bonus.basic_2.BonBasic2Controller;
import de.rtb.pcon.features.bonus.basic_2.BonBasic2Service;
import de.rtb.pcon.features.bonus.basic_2.BonBasic2UiLcnInidvidualProperties;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/zones/{id}/bonus/lpn/basic2"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class BonBasic2Controller {
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @PersistenceContext
    EntityManager entityManager;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private BonBasic2Service bonusService;

    BonBasic2Controller() {
    }

    @GetMapping(value={"properties"})
    @Transactional(readOnly=true)
    public BonBasic2UiLcnInidvidualProperties gtLncGetIndividualProperties(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        return this.bonusService.findByZone(zone).map(BonBasic2UiLcnInidvidualProperties::new).orElseGet(() -> new BonBasic2UiLcnInidvidualProperties(this.bonusService.createDefaultBonus(zone)));
    }

    @PutMapping(value={"properties"})
    @Transactional
    public BonBasic2UiLcnInidvidualProperties putLncGetIndividualProperties(@PathVariable(value="id") int zoneId, @RequestBody BonBasic2UiLcnInidvidualProperties uiBonus) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        BonBasic2ConfigEntity dbBonus = this.bonusService.findByZone(zone).orElseGet(() -> this.bonusService.save(this.bonusService.createDefaultBonus(zone)));
        BonBasic2UiLcnInidvidualProperties baseBonus = new BonBasic2UiLcnInidvidualProperties(dbBonus);
        dbBonus.setDuration(Duration.ofMinutes(uiBonus.getTime().intValue()));
        dbBonus.setEnabled(uiBonus.getEnabled().booleanValue());
        dbBonus.setGap(Duration.ofMinutes(uiBonus.getGap().intValue()));
        dbBonus.setMaxParkDays(uiBonus.getMaxParkDays().intValue());
        boolean isStartOfPermitMode = switch (1.$SwitchMap$de$rtb$pcon$features$bonus$basic_2$BonBasic2UiLcnInidvidualProperties$BonusMode[uiBonus.getMode().ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> true;
            case 2 -> false;
        };
        dbBonus.setStartOfPermitMode(isStartOfPermitMode);
        String logDiff = LoggerUtils.makeObjectDiff((Object)uiBonus, (Object)baseBonus);
        if (StringUtils.isNotEmpty((CharSequence)logDiff) && actionLogger.isInfoEnabled()) {
            actionLogger.info(LoggerUtils.formatObjectDiff((User)this.securityService.getCurrentUser(), (String)("LPN (individual) bonus of " + LoggerUtils.log((Zone)zone)), (String)logDiff));
        }
        return uiBonus;
    }
}

