/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import de.rtb.pcon.core.services.pdm_in.DebugContent;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmLogCatalog;
import de.rtb.pcon.model.PdmLogMessage;
import de.rtb.pcon.repositories.PdmLogCatalogRepository;
import de.rtb.pcon.repositories.PdmLogMessageRepository;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PdmLogService {
    private static final Logger log = LoggerFactory.getLogger(PdmLogService.class);
    private PdmLogMessageRepository logRepo;
    private PdmLogCatalogRepository catRepo;

    public PdmLogService(PdmLogMessageRepository logRepo, PdmLogCatalogRepository catRepo) {
        this.logRepo = logRepo;
        this.catRepo = catRepo;
    }

    @Transactional
    public void processActionLog(PdmMessageDto m) {
        if (m.getDbg() != null) {
            log.debug("~ Action log");
            m.getDbg().forEach(l -> this.saveLog(m.getPdm(), m.getDatTim(), l));
        }
    }

    void saveLog(Pdm pdm, OffsetDateTime pdmTimestamp, DebugContent dbg) {
        OffsetDateTime eventTimestamp;
        PdmLogMessage pdmLog = new PdmLogMessage();
        pdmLog.setPdm(pdm);
        pdmLog.setServerTime(OffsetDateTime.now());
        pdmLog.setLevel(NumberUtils.toShort((String)dbg.level()));
        if (pdmTimestamp == null) {
            pdmTimestamp = pdmLog.getServerTime();
        }
        if (dbg.time() != null) {
            ZoneId pdmZoneId = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
            LocalDate date = DateTimeUtils.toLocalDateTime((OffsetDateTime)pdmTimestamp, (ZoneId)pdmZoneId).toLocalDate();
            eventTimestamp = ZonedDateTime.of(date, dbg.time(), pdmZoneId).toOffsetDateTime();
        } else {
            eventTimestamp = pdmTimestamp;
        }
        pdmLog.setPdmTime(eventTimestamp);
        String text = StringUtils.trim((String)dbg.text());
        if (StringUtils.isBlank((CharSequence)text)) {
            text = "<no message>";
        }
        pdmLog.setText(text);
        String catalogName = StringUtils.trim((String)dbg.category());
        if (StringUtils.isBlank((CharSequence)catalogName)) {
            catalogName = "default";
        }
        String fCatalogName = catalogName;
        PdmLogCatalog catalog = this.catRepo.findByTitle(catalogName).orElseGet(() -> (PdmLogCatalog)this.catRepo.save((Object)new PdmLogCatalog(fCatalogName)));
        pdmLog.setCatalog(catalog);
        this.logRepo.save((Object)pdmLog);
    }
}

