/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.runtime_monitor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.core.runtime_monitor.AliveMonitorProperties;
import de.rtb.pcon.core.runtime_monitor.PdmRuntimeMonitorRepository;
import de.rtb.pcon.core.services.pdm_in.StatusMessageService;
import de.rtb.pcon.model.AccuLevel;
import de.rtb.pcon.model.NetworkType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmRuntimeMonitor;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AliveMonitorService {
    private static final Logger log = LoggerFactory.getLogger(AliveMonitorService.class);
    @Autowired
    private AliveMonitorProperties aliveMonitorProperties;
    @Autowired
    @Qualifier(value="transactionManager")
    protected PlatformTransactionManager txManager;
    @Autowired
    private PdmRuntimeMonitorRepository runtimeRepo;
    @Autowired
    private StatusMessageService statusMessageService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private PdmRepository pdmRepo;

    @Transactional
    public void init() {
        this.runtimeRepo.resetAliveStatusForOnline();
        this.runtimeRepo.resetLastKeepAlive();
    }

    @Transactional
    public void evaluateAliveStatus() {
        log.debug("Detecting alive changes.");
        int keeDefault = (int)this.aliveMonitorProperties.getDefaultAlive().toMinutes();
        int notifyAfterMissingNr = this.aliveMonitorProperties.getOfflineAfterMissingCount();
        List becomeOnline = this.runtimeRepo.findTransitingOnlineWithKeepAlive(keeDefault);
        List becomeOffline = this.runtimeRepo.findTransitingOfflineWithKeepAlive(keeDefault, notifyAfterMissingNr);
        HashSet<Integer> pdmIdsToFetch = new HashSet<Integer>();
        pdmIdsToFetch.addAll(becomeOnline.stream().map(pr -> pr.getPdm().getId()).toList());
        pdmIdsToFetch.addAll(becomeOffline.stream().map(pr -> pr.getPdm().getId()).toList());
        this.pdmRepo.findAllById(pdmIdsToFetch);
        if (!becomeOnline.isEmpty()) {
            log.debug("Number of PDMs become online {}", (Object)becomeOnline.size());
            this.runtimeRepo.setOnlineForPdms(Boolean.valueOf(true), becomeOnline.stream().map(PdmRuntimeMonitor::getPdm).toList());
        }
        becomeOnline.forEach(arg_0 -> this.insertStatusPdmIsOnline(arg_0));
        if (!becomeOffline.isEmpty()) {
            log.debug("Number of PDMs become offline {}", (Object)becomeOffline.size());
            this.runtimeRepo.setOnlineForPdms(Boolean.valueOf(false), becomeOffline.stream().map(PdmRuntimeMonitor::getPdm).toList());
        }
        becomeOffline.forEach(arg_0 -> this.insertStatusPdmIsOffline(arg_0));
        int nrOfWokenPdms = this.runtimeRepo.markWakingUp(keeDefault);
        if (nrOfWokenPdms > 0) {
            log.debug("Number of woken up PDMs {}", (Object)nrOfWokenPdms);
        }
    }

    private void insertStatusPdmIsOffline(PdmRuntimeMonitor prm) {
        Optional lastContact = AliveMonitorService.maxDateTime((OffsetDateTime[])new OffsetDateTime[]{prm.getLastKeepAlive(), prm.getPayTime(), prm.getStaTime(), prm.getClrTime(), prm.getSysTime()});
        Optional<Duration> aliveDuration = Optional.ofNullable(prm.getKeepAliveInterval());
        OffsetDateTime now = OffsetDateTime.now();
        Map<String, Object> reason = lastContact.isPresent() && aliveDuration.isPresent() ? Map.of("r", 0, "a", List.of(Long.valueOf(Duration.between((Temporal)lastContact.get(), now).toMinutes()), Long.valueOf(aliveDuration.get().toMinutes()))) : (lastContact.isPresent() ? Map.of("r", 1, "a", List.of(Long.valueOf(Duration.between((Temporal)lastContact.get(), now).toMinutes()))) : (aliveDuration.isPresent() ? Map.of("r", 2, "a", List.of(Long.valueOf(aliveDuration.get().toMinutes()))) : Map.of("r", 3)));
        Pdm pdm = (Pdm)this.pdmRepo.findById((Object)prm.getPdm().getId()).orElseThrow();
        ObjectNode reasonJson = (ObjectNode)this.objectMapper.convertValue(reason, ObjectNode.class);
        this.statusMessageService.insertArtificialMessage(pdm, 1300, reasonJson);
    }

    private void insertStatusPdmIsOnline(PdmRuntimeMonitor prm) {
        Pdm pdm = (Pdm)this.pdmRepo.findById((Object)prm.getPdm().getId()).orElseThrow();
        this.statusMessageService.insertArtificialMessage(pdm, 1301);
    }

    public static Optional<OffsetDateTime> maxDateTime(OffsetDateTime ... dt) {
        OffsetDateTime max = OffsetDateTime.MIN;
        for (OffsetDateTime d : dt) {
            if (d == null || !d.isAfter(max)) continue;
            max = d;
        }
        if (max.equals(OffsetDateTime.MIN)) {
            return Optional.empty();
        }
        return Optional.of(max);
    }

    @Transactional
    public void recievedAliveMessage(PdmRuntimeMonitor rm, Duration keepAliveInterval) {
        rm.setKeepAliveInterval(keepAliveInterval);
        rm.setLastKeepAlive(OffsetDateTime.now());
    }

    @Transactional
    public void recievedPaymentMessage(PdmRuntimeMonitor rm, int tracer) {
        rm.setPayTracer(Integer.valueOf(tracer));
        rm.setPayTime(OffsetDateTime.now());
    }

    @Transactional
    public void recievedStatusMessage(PdmRuntimeMonitor rm, OffsetDateTime time, int tracer, int msgNr) {
        rm.setStaTracer(Integer.valueOf(tracer));
        rm.setStaTime(OffsetDateTime.now());
        if (56 == msgNr) {
            rm.setLastService(time);
        }
    }

    @Transactional
    public void recievedClearingMessage(PdmRuntimeMonitor rm, int tracer) {
        rm.setClrTracer(Integer.valueOf(tracer));
        rm.setClrTime(OffsetDateTime.now());
    }

    @Transactional
    public void recievedSystemMessage(PdmRuntimeMonitor rm, int tracer) {
        rm.setSysTracer(Integer.valueOf(tracer));
        rm.setSysTime(OffsetDateTime.now());
    }

    @Transactional
    public void updateModemStatus(PdmRuntimeMonitor rm, Integer netSignal, NetworkType netType, OffsetDateTime pdmTime) {
        rm.setNetSignal(netSignal);
        rm.setNetType(netType);
        rm.setNetLogin(pdmTime);
    }

    @Transactional
    public void updateAccuLevel(PdmRuntimeMonitor rm, AccuLevel accuLevel) {
        rm.setPowerTime(accuLevel.getPdmTime());
        rm.setPowerVoltage(accuLevel.getVoltageAvg());
        rm.setPowMcsSol(accuLevel.getPowMcsSol());
        rm.setPowSvenIn(accuLevel.getPowSvenIn());
        rm.setPowSvenBat(accuLevel.getPowSvenBat());
    }

    @Transactional(readOnly=true)
    public Optional<PdmRuntimeMonitor> getRuntimeInfo(Pdm pdm) {
        return this.runtimeRepo.findByPdm(pdm);
    }

    @Transactional
    public PdmRuntimeMonitor provideRuntimeMonitor(Pdm pdm) {
        Optional pdmRuntime = this.runtimeRepo.findByPdm(pdm);
        if (pdmRuntime.isPresent()) {
            return (PdmRuntimeMonitor)pdmRuntime.get();
        }
        PdmRuntimeMonitor rm = new PdmRuntimeMonitor();
        rm.setPdm(pdm);
        rm.setOnline(Boolean.valueOf(true));
        log.debug("Created new run time monitor for PDM #{}", (Object)pdm.getId());
        return (PdmRuntimeMonitor)this.runtimeRepo.save((Object)rm);
    }

    @Transactional(readOnly=true)
    public Optional<OffsetDateTime> getNextKeepAlive(Pdm pdm) {
        return this.runtimeRepo.findByPdm(pdm).flatMap(rm -> {
            if (rm.getLastKeepAlive() == null || rm.getKeepAliveInterval() == null) {
                return Optional.empty();
            }
            return Optional.of(rm.getLastKeepAlive().plus(rm.getKeepAliveInterval()));
        });
    }
}

