/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.hw_runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmHwStatus;
import de.rtb.pcon.repositories.PdmHwStatusRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HardwareRuntimeMonitorService {
    private final ObjectMapper stdObjectMapper;
    private final PdmHwStatusRepository pdmHardwareRepo;

    public HardwareRuntimeMonitorService(ObjectMapper stdObjectMapper, PdmHwStatusRepository pdmHardwareRepo) {
        this.stdObjectMapper = stdObjectMapper;
        this.pdmHardwareRepo = pdmHardwareRepo;
    }

    @Transactional
    public void processRuntimeReport(PdmMessageDto m) {
        if (m.getSdl() == null) {
            return;
        }
        ObjectNode report = m.getSdl();
        PdmHwStatus dbReportEntity = this.pdmHardwareRepo.findByPdm(m.getPdm()).orElseGet(() -> (PdmHwStatus)this.pdmHardwareRepo.save((Object)PdmHwStatus.fromPdm((Pdm)m.getPdm())));
        ObjectNode dbRootNode = this.parseDbReport(dbReportEntity.getStatus());
        String operation = report.at("/@meta/op").asText("put").toLowerCase();
        report.remove("@meta");
        try {
            switch (operation) {
                case "add": {
                    report.fields().forEachRemaining(entry -> dbRootNode.set((String)entry.getKey(), (JsonNode)entry.getValue()));
                    dbReportEntity.setStatus(this.stdObjectMapper.writeValueAsString((Object)dbRootNode));
                    break;
                }
                case "del": {
                    report.fieldNames().forEachRemaining(arg_0 -> ((ObjectNode)dbRootNode).remove(arg_0));
                    dbReportEntity.setStatus(this.stdObjectMapper.writeValueAsString((Object)dbRootNode));
                    break;
                }
                default: {
                    dbReportEntity.setStatus(this.stdObjectMapper.writeValueAsString((Object)report));
                    break;
                }
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Can't store hardware runtime", e);
        }
    }

    private ObjectNode parseDbReport(String report) {
        try {
            if (StringUtils.isBlank((CharSequence)report)) {
                return this.stdObjectMapper.createObjectNode();
            }
            return (ObjectNode)this.stdObjectMapper.readTree(report);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("DB hardware report could not be parsed", e);
        }
    }
}

