/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download;

import de.rtb.pcon.core.fw_download.FirmwareDownloadServiceIp;
import de.rtb.pcon.core.fw_download.WanProps;
import de.rtb.pcon.core.integration.ServerResponseBinary;
import de.rtb.pcon.core.integration.ServerResponseJson;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.core.services.pdm_in.SoftwareDataProvider;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.DownloadStatus;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.model.download.SoftwareItem;
import java.time.LocalDate;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pdmFirmwareDownloadTcp")
public class FirmwareDownloadServiceTcp
extends FirmwareDownloadServiceIp {
    private static final Logger logger = LoggerFactory.getLogger(FirmwareDownloadServiceTcp.class);
    private final SoftwareDataProvider swDataProvider;

    public FirmwareDownloadServiceTcp(WanProps config, SoftwareDataProvider swDataProvider) {
        super(config.getIp(), config.getTcpPort());
        this.swDataProvider = swDataProvider;
    }

    @Transactional
    public void getMetaData(PdmMessageDto m, ServerResponseJson response) {
        Optional downloadItem = this.getFirmwareDescription(m.getPdm(), DownloadTarget.fromUty((int)m.getUty()));
        if (downloadItem.isPresent()) {
            DownloadEntry di = (DownloadEntry)downloadItem.get();
            DownloadPlan plan = di.getPlan();
            SoftwareItem swi = this.swDataProvider.getSoftwareItem(di.getPlan().getSoftwareDescription(), di.getPath());
            this.appendFwMetaDataToResponse(response, plan.getDownloadTarget(), swi.getLength(), plan.getActivationDate(), swi.getCrc());
            di.setStatus(DownloadStatus.IN_PROGRESS);
        } else {
            logger.warn("Requested download item doesn't exist. Sending fake data.");
            this.appendFwMetaDataToResponse(response, DownloadTarget.fromUty((int)m.getUty()), 0, LocalDate.now().minusDays(7L), "0000");
        }
    }

    private void appendFwMetaDataToResponse(ServerResponseJson response, DownloadTarget dt, int fileSizeInBytes, LocalDate activatDate, String crc) {
        response.append("UTY", (Object)dt.uty());
        response.append("DGA", (Object)activatDate.format(DGA_TIME_FORMATTER));
        response.append("AFB", (Object)Integer.toHexString(fileSizeInBytes).toUpperCase());
        response.append("FCC", (Object)crc);
    }

    @Transactional
    public ServerResponseBinary getFilePart(PdmMessageDto m) {
        DownloadTarget dt = DownloadTarget.fromUty((int)m.getUty());
        Pdm pdm = m.getPdm();
        byte[] data = this.getFirmwareDescription(pdm, dt).map(de -> this.getFilePartData(pdm, dt, m.getFsa().intValue(), m.getFsi().intValue(), de.getPath())).orElse(ArrayUtils.EMPTY_BYTE_ARRAY);
        return new ServerResponseBinary(data);
    }
}

