/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.remote_data_acces;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import de.rtb.pcon.model.Pdm;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(name="PDM", description="Park and Display Machine.")
class ExportedPdmDao {
    @Schema(description="PDM's unique number.")
    @JacksonXmlProperty(isAttribute=true)
    private int id;
    @Schema(description="Number assigned to PDM by user")
    @JacksonXmlProperty(localName="nr", isAttribute=true)
    private int number;
    @Schema(description="Name assigned to PDM by user")
    @JacksonXmlText
    private String name;
    @Schema(description="PDM location / latitude")
    @JsonProperty(value="lat")
    @JacksonXmlProperty(localName="lat", isAttribute=true)
    private Double latitude;
    @Schema(description="PDM location / longitude")
    @JsonProperty(value="lon")
    @JacksonXmlProperty(localName="lon", isAttribute=true)
    private Double longitude;

    public ExportedPdmDao(Pdm pdm) {
        this.id = pdm.getId();
        this.number = pdm.getNumber();
        this.name = pdm.getName();
        this.latitude = pdm.getLatitude();
        this.longitude = pdm.getLongitude();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }
}

