/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcontrol.utils;

import jakarta.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExportHelper {
    public static final String FILE_SUFFIX_EXCEL = ".xlsx";
    private int rowIndex = -1;
    private int colIndex = -1;
    private XSSFWorkbook workbook;
    private XSSFSheet sheet;
    private XSSFRow row;
    public static final String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

    public static void setHttpResponseHeaders(HttpServletResponse response, String fileName) {
        response.setContentType(CONTENT_TYPE);
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Date", ZonedDateTime.now(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME));
        if (fileName != null) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + ".xlsx\"");
        }
    }

    public XSSFCellStyle createHeaderRowStyle() {
        XSSFCellStyle headerStyle = this.workbook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setBorderBottom(BorderStyle.DOUBLE);
        XSSFFont headerFont = this.workbook.createFont();
        headerFont.setBold(true);
        headerStyle.setFont((Font)headerFont);
        return headerStyle;
    }

    public XSSFCellStyle createHeaderColStyle() {
        XSSFCellStyle headerStyle = this.workbook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setBorderRight(BorderStyle.DOUBLE);
        XSSFFont headerFont = this.workbook.createFont();
        headerFont.setBold(true);
        headerStyle.setFont((Font)headerFont);
        return headerStyle;
    }

    public XSSFCellStyle createStyleWithFont() {
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFFont font = this.workbook.createFont();
        style.setFont((Font)font);
        return style;
    }

    public XSSFCellStyle createDateTimeStyle(String format) {
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFCreationHelper createHelper = this.workbook.getCreationHelper();
        style.setDataFormat(createHelper.createDataFormat().getFormat(format));
        return style;
    }

    public static void autoFitColums(XSSFSheet sheet) {
        XSSFRow headingRow = sheet.getRow(0);
        int rowColNumber = 0;
        for (Cell cell : headingRow) {
            sheet.autoSizeColumn(rowColNumber++);
        }
    }

    public XSSFWorkbook createWorkbook() {
        this.workbook = new XSSFWorkbook();
        return this.workbook;
    }

    public XSSFSheet addSheet(String name) {
        this.rowIndex = -1;
        this.colIndex = -1;
        this.sheet = this.workbook.createSheet(WorkbookUtil.createSafeSheetName((String)name));
        return this.sheet;
    }

    public void addHeaderRow(String ... labels) {
        XSSFCellStyle headerCellStyle = this.createHeaderRowStyle();
        this.addRow();
        for (String label : labels) {
            XSSFCell cell = this.addCell();
            cell.setCellValue(label);
            cell.setCellStyle((CellStyle)headerCellStyle);
        }
    }

    public void addHeaderRow(List<String> labels) {
        XSSFCellStyle headerCellStyle = this.createHeaderRowStyle();
        this.addRow();
        for (String label : labels) {
            XSSFCell cell = this.addCell();
            cell.setCellValue(label);
            cell.setCellStyle((CellStyle)headerCellStyle);
        }
    }

    public XSSFRow addRow() {
        this.row = this.sheet.createRow(++this.rowIndex);
        this.colIndex = -1;
        return this.row;
    }

    public XSSFCell addCell() {
        XSSFCell cell = this.row.createCell(++this.colIndex);
        return cell;
    }

    public XSSFCell addCell(XSSFCellStyle style) {
        XSSFCell cell = this.row.createCell(++this.colIndex);
        cell.setCellStyle((CellStyle)style);
        return cell;
    }

    public XSSFCell addCell(XSSFCellStyle style, LocalDateTime dateTime) {
        XSSFCell cell = this.addCell();
        cell.setCellStyle((CellStyle)style);
        if (dateTime != null) {
            cell.setCellValue(Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()));
        } else {
            cell.setCellValue("");
        }
        return cell;
    }

    public XSSFCell addCell(XSSFCellStyle style, LocalDate date) {
        LocalDateTime dateTime = LocalDateTime.of(date, LocalTime.of(0, 0));
        return this.addCell(style, dateTime);
    }

    public int rowIndex() {
        return this.rowIndex;
    }

    public int colIndex() {
        return this.colIndex;
    }

    public void addWarningBox(String headline, String description) {
        if (this.rowIndex == -1) {
            throw new AssertionError((Object)"Warning box must not be located on the first line. Otherwise it would not be possilbe to meassure the row width.");
        }
        int lastCellNumber = this.sheet.getRow(0).getLastCellNum() - 1;
        XSSFFont wariningBigFont = this.workbook.createFont();
        wariningBigFont.setFontHeightInPoints((short)36);
        XSSFCellStyle warningCellStyleBig = this.workbook.createCellStyle();
        warningCellStyleBig.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        warningCellStyleBig.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        warningCellStyleBig.setAlignment(HorizontalAlignment.CENTER);
        warningCellStyleBig.setFont((Font)wariningBigFont);
        XSSFCellStyle warningCellStyleSmall = this.workbook.createCellStyle();
        warningCellStyleSmall.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        warningCellStyleSmall.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        warningCellStyleSmall.setAlignment(HorizontalAlignment.CENTER);
        XSSFRow warningRowBig = this.addRow();
        XSSFCell warnCellBig = warningRowBig.createCell(0);
        warnCellBig.setCellValue(headline);
        warnCellBig.setCellStyle((CellStyle)warningCellStyleBig);
        this.sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, lastCellNumber));
        XSSFRow warningRowSmall = this.addRow();
        XSSFCell warnCellSmall = warningRowSmall.createCell(0);
        warnCellSmall.setCellValue(description);
        warnCellSmall.setCellStyle((CellStyle)warningCellStyleSmall);
        this.sheet.addMergedRegion(new CellRangeAddress(2, 2, 0, lastCellNumber));
    }
}

