/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.clearing.Clearing;
import de.rtb.pcon.ui.controllers.model.UiMoney;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

public class UiClearingLog {
    private long id;
    private int pdm;
    private Integer cn;
    private UiMoney amount;
    private PaymentType type;
    private LocalDateTime time;
    private LocalDateTime received;
    private Integer asn;

    public UiClearingLog(Clearing c, ZoneId userTimeZone) {
        this.id = c.getId();
        this.pdm = c.getPdm().getId();
        this.cn = c.getClearingNumber();
        this.amount = new UiMoney(c.getValueSold(), c.getCurrency());
        this.type = c.getPaymentType();
        this.time = DateTimeUtils.toLocalDateTime((OffsetDateTime)c.getPdmTime(), (ZoneId)userTimeZone);
        this.received = DateTimeUtils.toLocalDateTime((OffsetDateTime)c.getServerTime(), (ZoneId)userTimeZone);
        this.asn = c.getAsn();
    }

    @JsonGetter(value="type")
    public Integer getTypeJson() {
        return this.type != null ? Integer.valueOf(this.type.getValue()) : null;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setPdm(int pdm) {
        this.pdm = pdm;
    }

    public int getPdm() {
        return this.pdm;
    }

    public long getId() {
        return this.id;
    }

    public Integer getCn() {
        return this.cn;
    }

    public void setCn(Integer cn) {
        this.cn = cn;
    }

    public UiMoney getAmount() {
        return this.amount;
    }

    public void setAmount(UiMoney amount) {
        this.amount = amount;
    }

    public PaymentType getType() {
        return this.type;
    }

    public void setType(PaymentType payType) {
        this.type = payType;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public void setTime(LocalDateTime time) {
        this.time = time;
    }

    public LocalDateTime getReceived() {
        return this.received;
    }

    public void setReceived(LocalDateTime recieved) {
        this.received = recieved;
    }

    public Integer getAsn() {
        return this.asn;
    }

    public void setAsn(Integer asn) {
        this.asn = asn;
    }
}

