/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.model;

import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.clearing.CashClearing;
import de.rtb.pcon.model.clearing.Clearing;
import de.rtb.pcon.model.clearing.OcifCardClearing;
import de.rtb.pcon.ui.controllers.model.UiClearingDetail;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;

public class UiClearingDetail {
    private Integer pdm;
    private LocalDateTime pdmTime;
    private String currency;
    private Integer ticketCount;
    private BigDecimal valueSold;
    private BigDecimal valueCharged;
    private BigDecimal valueLifeLong;
    private PaymentType paymentType;
    private Integer clearingNumber;
    private String accountName;
    private Integer asn;
    private List<UiCashBoxItem> cashBox;
    private List<UiPreviousClearingItem> previousClearings;

    public UiClearingDetail(Clearing clearing, ZoneId timeZone, List<Clearing> previousClearings) {
        this.pdm = clearing.getPdm().getId();
        this.pdmTime = DateTimeUtils.toLocalDateTime((OffsetDateTime)clearing.getPdmTime(), (ZoneId)timeZone);
        this.currency = clearing.getCurrency();
        this.ticketCount = clearing.getTicketCount();
        this.paymentType = clearing.getPaymentType();
        this.ticketCount = clearing.getTicketCount();
        this.valueLifeLong = clearing.getValueLifeLong();
        this.valueSold = clearing.getValueSold();
        this.clearingNumber = clearing.getClearingNumber();
        this.asn = clearing.getAsn();
        if (clearing instanceof CashClearing) {
            CashClearing cashClearing = (CashClearing)clearing;
            this.valueCharged = cashClearing.getValueRecharged();
            this.cashBox = cashClearing.getCashBox().stream().map(UiCashBoxItem::new).toList();
        }
        if (clearing instanceof OcifCardClearing) {
            OcifCardClearing ocifClearing = (OcifCardClearing)clearing;
            this.accountName = ocifClearing.getAccountName();
        }
        this.previousClearings = previousClearings.stream().map(c -> new UiPreviousClearingItem(c, timeZone)).toList();
    }

    public Integer getPdm() {
        return this.pdm;
    }

    public void setPdm(Integer pdm) {
        this.pdm = pdm;
    }

    public LocalDateTime getPdmTime() {
        return this.pdmTime;
    }

    public void setPdmTime(LocalDateTime pdmTime) {
        this.pdmTime = pdmTime;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Integer getTicketCount() {
        return this.ticketCount;
    }

    public void setTicketCount(Integer ticketCount) {
        this.ticketCount = ticketCount;
    }

    public BigDecimal getValueSold() {
        return this.valueSold;
    }

    public void setValueSold(BigDecimal valueSold) {
        this.valueSold = valueSold;
    }

    public BigDecimal getValueCharged() {
        return this.valueCharged;
    }

    public void setValueCharged(BigDecimal valueCahrged) {
        this.valueCharged = valueCahrged;
    }

    public BigDecimal getValueLifeLong() {
        return this.valueLifeLong;
    }

    public void setValueLifeLong(BigDecimal valueLifeLong) {
        this.valueLifeLong = valueLifeLong;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType value) {
        this.paymentType = value;
    }

    public List<UiCashBoxItem> getCashBox() {
        return this.cashBox;
    }

    public void setCashBox(List<UiCashBoxItem> cashBox) {
        this.cashBox = cashBox;
    }

    public Integer getClearingNumber() {
        return this.clearingNumber;
    }

    public void setClearingNumber(Integer clearingNumber) {
        this.clearingNumber = clearingNumber;
    }

    public Integer getAsn() {
        return this.asn;
    }

    public void setAsn(Integer asn) {
        this.asn = asn;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public List<UiPreviousClearingItem> getPreviousClearings() {
        return this.previousClearings;
    }
}

