/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmStatus;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.repositories.PdmStatusRepository;
import de.rtb.pcon.ui.controllers.UiProblemOverview;
import de.rtb.pcon.ui.controllers.model.UiPdmWithIssue;
import de.rtb.pcon.ui.controllers.model.UiStatusMessage;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.PdmService;
import de.rtb.pcon.ui.services.SecurityService;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/overview2"})
public class OverviewController {
    private final I18nService i18n;
    private final SecurityService securityService;
    private final PdmService pdmService;
    private final PdmStatusRepository pdmStatusRepo;

    public OverviewController(I18nService i18n, SecurityService securityService, PdmService pdmService, PdmStatusRepository pdmStatusRepo) {
        this.i18n = i18n;
        this.securityService = securityService;
        this.pdmService = pdmService;
        this.pdmStatusRepo = pdmStatusRepo;
    }

    @GetMapping(value={"issues"})
    public UiProblemOverview getProblems() {
        Map issueMap = this.pdmService.countPdmsWithIssue();
        int errorCount = Optional.ofNullable((Integer)issueMap.get(AlertType.CRITICAL)).orElse(0) + Optional.ofNullable((Integer)issueMap.get(AlertType.ERROR)).orElse(0);
        int warningCount = Optional.ofNullable((Integer)issueMap.get(AlertType.WARNING)).orElse(0);
        return new UiProblemOverview(warningCount, errorCount);
    }

    @GetMapping(value={"open_messages/list"})
    @Transactional(readOnly=true)
    public List<UiPdmWithIssue> listPdmsWithOpenMessages(Authentication authentication) {
        ZoneId timeZone = this.i18n.userTimeZoneId();
        boolean showAllStatusMessages = UserRole.containsRole((Authentication)authentication, (UserRole)UserRole.ROLE_PCON_SUPPORT);
        List userAreas = this.securityService.getCurrentAreas();
        List openStatusMessages = this.pdmStatusRepo.findInAreas((Collection)userAreas, showAllStatusMessages);
        Map appData = openStatusMessages.stream().collect(Collectors.groupingBy(PdmStatus::getPdm, Collectors.mapping(st -> st, Collectors.toList())));
        ArrayList<UiPdmWithIssue> uiResult = new ArrayList<UiPdmWithIssue>(appData.size());
        for (Map.Entry entry : appData.entrySet()) {
            Pdm pdm = entry.getKey();
            List pdmStatuses = entry.getValue();
            List<UiStatusMessage> pdmIssues = pdmStatuses.stream().map(s -> new UiStatusMessage(s, timeZone)).toList();
            uiResult.add(new UiPdmWithIssue(pdm, pdmIssues));
        }
        return uiResult;
    }
}

