/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.repositories;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmStatus;
import de.rtb.pcon.repositories.PdmStatusRepository;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;

public interface PdmStatusRepository
extends CrudRepository<PdmStatus, Long> {
    @Modifying
    @Query(value="INSERT INTO control.pdm_status (pds_pdm_id, pds_log_id, pds_msg_nr) VALUES (:pdmId, :statusId, :nr) ON CONFLICT DO NOTHING", nativeQuery=true)
    public void setStatus(int var1, int var2, long var3);

    @Modifying
    @Query(value="DELETE FROM control.pdm_status USING control.logbook, control.message_config_default WHERE     pds_pdm_id = :pdmId AND     pds_log_id = logbook.log_id AND     log_msg_nr = message_config_default.mcd_number AND     message_config_default.mcd_solve = :nr", nativeQuery=true)
    public void removeStatus(int var1, int var2);

    public Optional<PdmStatus> findByPdmAndMessageConfigNumber(Pdm var1, short var2);

    @EntityGraph(attributePaths={"statusMessage", "messageConfig", "pdm"})
    public List<PdmStatus> findByPdmZoneAreaIn(Collection<Area> var1);

    @EntityGraph(attributePaths={"statusMessage", "messageConfig", "pdm"})
    public List<PdmStatus> findByPdmZoneAreaInAndMessageConfigEssentialTrue(Collection<Area> var1);

    default public List<PdmStatus> findInAreas(Collection<Area> areas, boolean showAll) {
        return showAll ? this.findByPdmZoneAreaIn(areas) : this.findByPdmZoneAreaInAndMessageConfigEssentialTrue(areas);
    }

    @Query(value="SELECT s, mcd, mcu FROM PdmStatus s JOIN FETCH s.statusMessage JOIN FETCH s.pdm p JOIN FETCH p.zone z JOIN s.messageConfig mcd LEFT JOIN MessageConfigUser mcu ON mcu.number = mcd.number AND mcu.area = z.area WHERE p IN (:pdms)\n")
    public List<PdmStatusWithUserConfig> fetchStatusesWithDefaultConfig(Collection<Pdm> var1);

    @Query(value="SELECT s, mcd, mcu FROM PdmStatus s JOIN FETCH s.statusMessage JOIN FETCH s.pdm p JOIN FETCH p.zone z JOIN s.messageConfig mcd LEFT JOIN MessageConfigUser mcu ON mcu.number = mcd.number AND mcu.area = z.area WHERE p IN (:pdms) AND s.messageConfig.essential = true\n")
    public List<PdmStatusWithUserConfig> fetchEssentialStatusesWithDefaultConfig(Collection<Pdm> var1);

    default public List<PdmStatusWithUserConfig> findOpenStatusMessages(Collection<Pdm> pdms, boolean showAll) {
        return showAll ? this.fetchStatusesWithDefaultConfig(pdms) : this.fetchEssentialStatusesWithDefaultConfig(pdms);
    }
}

