/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.ftt;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.PartnerUtils;
import de.rtb.pcon.features.partners.ftt.FttConfigDto;
import de.rtb.pcon.features.partners.ftt.FttConfigService;
import de.rtb.pcon.features.partners.ftt.FttConfigZone;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/ftt/"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class FttController {
    @Autowired
    private FttConfigService cfgService;
    @Autowired
    private SecureEntityLoaderService entityLoader;

    FttController() {
    }

    @GetMapping(value={"config"})
    @Transactional(readOnly=true)
    public FttConfigDto getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        FttConfigDto cfg = (FttConfigDto)this.cfgService.fetchConfig(area);
        List uiZones = PartnerUtils.adjustZones((List)area.getZones(), (List)cfg.zones(), rtbId -> new FttConfigZone(Integer.valueOf(rtbId), ""));
        return new FttConfigDto(cfg.enabled(), cfg.url(), cfg.authorization(), cfg.providerId(), cfg.errorEmail(), uiZones);
    }

    @PostMapping(value={"config"})
    @Transactional
    public void setConfig(@PathVariable int id, @RequestBody FttConfigDto config) {
        Area area = this.entityLoader.loadArea(id);
        List<FttConfigZone> zones = PartnerUtils.adjustZones((List)area.getZones(), (List)config.zones(), rtbId -> new FttConfigZone(Integer.valueOf(rtbId), "")).stream().filter(z -> StringUtils.isNotEmpty((CharSequence)z.fttId())).toList();
        FttConfigDto newConfig = new FttConfigDto(config.enabled(), config.url(), config.authorization(), config.providerId(), config.errorEmail(), zones);
        this.cfgService.updateConfig(area, (PartnerConfiguration)newConfig);
    }

    @DeleteMapping(value={"config"})
    @Transactional
    public void deleteConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        this.cfgService.deleteConfig(area, AreaPartnerType.FTT);
    }
}

