/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.boot_app.ApplicationContextHolder;
import org.apache.commons.lang3.exception.UncheckedException;
import org.jspecify.annotations.Nullable;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static @Nullable String writeValueAsString(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        ObjectMapper objectMapper = (ObjectMapper)ApplicationContextHolder.getBean(ObjectMapper.class);
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public static <T> @Nullable T readValue(String jsonString, Class<T> valueType) {
        if (jsonString == null) {
            return null;
        }
        ObjectMapper objectMapper = (ObjectMapper)ApplicationContextHolder.getBean(ObjectMapper.class);
        try {
            return (T)objectMapper.readValue(jsonString, valueType);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public static <T> @Nullable T readValue(String jsonString, TypeReference<T> valueTypeRef) {
        if (jsonString == null) {
            return null;
        }
        ObjectMapper objectMapper = (ObjectMapper)ApplicationContextHolder.getBean(ObjectMapper.class);
        try {
            return (T)objectMapper.readValue(jsonString, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedException((Throwable)e);
        }
    }
}

