/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_2;

import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleEntity;
import de.rtb.pcon.model.zone.Zone;
import jakarta.persistence.QueryHint;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;

interface BonMt2RuleRepository
extends JpaRepository<BonMt2RuleEntity, Integer> {
    public Optional<BonMt2RuleEntity> findByLpnAndZone(String var1, Zone var2);

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM control.bonus_lpn_mt2_rule WHERE (valid_to + cast(expiry_tolerance || ' days' as interval)) < now()")
    public int deleteExpiredEntries();

    @QueryHints(value={@QueryHint(name="org.hibernate.fetchSize", value="10000")})
    public Stream<BonMt2RuleEntity> streamByZoneOrderByLpn(Zone var1);

    public Page<BonMt2RuleEntity> findByZone(Zone var1, Pageable var2);

    public Page<BonMt2RuleEntity> findByZoneOrderByLpn(Zone var1, Pageable var2);

    @Modifying
    @Query(nativeQuery=true, value="INSERT INTO control.bonus_lpn_mt2_rule (lpn, valid_from, valid_to, tariff_name, expiry_tolerance, zone_id) VALUES(?1, ?2, ?3, ?4, ?5, ?6) ON CONFLICT ON CONSTRAINT uk_bonus_lpn_mt2__lpn_zone DO UPDATE SET valid_from = ?2, valid_to = ?3, tariff_name = ?4, expiry_tolerance = ?5 ")
    public int insertOrUpdate(String var1, OffsetDateTime var2, OffsetDateTime var3, String var4, Integer var5, Integer var6);

    @Modifying
    public void deleteByZone(Zone var1);

    public int countByZone(Zone var1);

    public Optional<BonMt2RuleEntity> findByZoneAndId(Zone var1, int var2);
}

