/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_2;

import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleEntity;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

class BonMt2RuleDao {
    private LocalDateTime from;
    private LocalDateTime to;
    private LocalDateTime renew;
    private String tariff;

    public BonMt2RuleDao(BonMt2RuleEntity rule, ZoneId timeZone) {
        this.from = DateTimeUtils.toLocalDateTime((OffsetDateTime)rule.getValidFrom(), (ZoneId)timeZone);
        this.to = DateTimeUtils.toLocalDateTime((OffsetDateTime)rule.getValidTo(), (ZoneId)timeZone);
        this.renew = this.to.plusDays(rule.getExpiryToleranceInDays().intValue());
        this.tariff = rule.getTariffName();
    }

    public LocalDateTime getFrom() {
        return this.from;
    }

    public LocalDateTime getTo() {
        return this.to;
    }

    public LocalDateTime getRenew() {
        return this.renew;
    }

    public String getTariff() {
        return this.tariff;
    }
}

