/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.user_data;

import org.apache.commons.lang3.StringUtils;

record UserDataFileName(String group, String name) {
    private final String group;
    private final String name;
    public static final String GROUP_SEPARATOR = "/";

    UserDataFileName(String group, String name) {
        this.group = group;
        this.name = name;
    }

    static final UserDataFileName fromString(String fullFileName) {
        int lastPathSeparator = StringUtils.lastIndexOf((CharSequence)fullFileName, (CharSequence)GROUP_SEPARATOR);
        if (lastPathSeparator != -1) {
            String group = fullFileName.substring(0, lastPathSeparator);
            String name = fullFileName.substring(lastPathSeparator + 1);
            return new UserDataFileName(group, name);
        }
        return new UserDataFileName("", fullFileName);
    }

    public String groupAndName() {
        if (StringUtils.isNotEmpty((CharSequence)this.group)) {
            return this.group + GROUP_SEPARATOR + this.name;
        }
        return this.name;
    }

    public String group() {
        return this.group;
    }

    public String name() {
        return this.name;
    }
}

