/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.core.cash_box.CashBoxMonitorService;
import de.rtb.pcon.core.fw_download.FirmwareDownloadService;
import de.rtb.pcon.core.fw_download.FirmwareDownloadServiceFactory;
import de.rtb.pcon.core.fw_download.FirmwareDownloadServiceHelper;
import de.rtb.pcon.core.hw_components.HardwarePartsMonitorService;
import de.rtb.pcon.core.hw_runtime.HardwareRuntimeMonitorService;
import de.rtb.pcon.core.integration.PdmMessageDuplicated;
import de.rtb.pcon.core.integration.PdmMessageRawDto;
import de.rtb.pcon.core.integration.ServerResponse;
import de.rtb.pcon.core.integration.ServerResponseJson;
import de.rtb.pcon.core.msg_presistence.ClearingTransactionService;
import de.rtb.pcon.core.msg_presistence.PaymentTransactionService;
import de.rtb.pcon.core.msg_presistence.payment.cpf.CustomPaymentFieldService;
import de.rtb.pcon.core.printer_monitor.PrinterService;
import de.rtb.pcon.core.real_time_request.RealTimeRequestRegisterService;
import de.rtb.pcon.core.remote_actions.RemoteActionSevice;
import de.rtb.pcon.core.runtime_monitor.AliveMonitorService;
import de.rtb.pcon.core.runtime_monitor.ModemLogingService;
import de.rtb.pcon.core.runtime_monitor.PowerMonitorService;
import de.rtb.pcon.core.runtime_monitor.TariffService;
import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import de.rtb.pcon.core.services.pdm_in.PdmLogService;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.core.services.pdm_in.StatusMessageService;
import de.rtb.pcon.core.trc_check.TrcCheckService;
import de.rtb.pcon.features.partners.PaymentForeignRetisterService;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmRuntimeMonitor;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.repositories.PaymentTransactionRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.services.PdmService;
import de.rtb.pcontrol.utils.DateTimeFormats;
import de.rtb.pcontrol.utils.PdmTextEncoder;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MessageParserService {
    private static final Logger logger = LoggerFactory.getLogger(MessageParserService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PaymentTransactionService paymentService;
    @Autowired
    private StatusMessageService staustService;
    @Autowired
    private ClearingTransactionService clearingService;
    @Autowired
    private FirmwareDownloadServiceFactory fwdsFactory;
    @Autowired
    private PdmService pdmService;
    @Autowired
    private AliveMonitorService aliveMonitorService;
    @Autowired
    private TrcCheckService trcCheckService;
    @Autowired
    private RemoteActionSevice remoteActionService;
    @Autowired
    private RealTimeRequestRegisterService realTimeRequestService;
    @Autowired
    private HardwarePartsMonitorService hwPartsMonitorService;
    @Autowired
    private HardwareRuntimeMonitorService hwRuntimeMonitorService;
    @Autowired
    private TariffService tariffSevice;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private MessageParserHelper messageParserHelper;
    @Autowired
    private CashBoxMonitorService cashBoxLevelSerivice;
    @Autowired
    private ModemLogingService modemLoginService;
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmObjectMapper;
    @Autowired
    private PowerMonitorService powerMonitorService;
    @Autowired
    private CustomPaymentFieldService cpfService;
    @Autowired
    private PaymentForeignRetisterService paymentTransportService;
    @Autowired
    private PdmLogService logService;
    @Autowired(required=false)
    private BuildProperties buildProperties;
    @Autowired
    private PaymentTransactionRepository paymentRepo;
    @Autowired
    private PdmRepository pdmRepo;
    @Autowired
    private ObservationRegistry observationRegistry;
    private String pconVesrionString;

    @PostConstruct
    void setBackendVersion() {
        if (this.buildProperties != null && this.buildProperties.getVersion() != null) {
            String realVersion = StringUtils.substringBefore((String)this.buildProperties.getVersion(), (String)"-");
            this.pconVesrionString = MessageParserService.createPconVersionForPdm((String)realVersion);
        } else {
            this.pconVesrionString = "1.99.99";
        }
    }

    static String createPconVersionForPdm(String realVersion) {
        String[] vc = StringUtils.split((String)realVersion, (char)'.');
        StringBuilder pconVersionBuilder = new StringBuilder("1");
        for (int i = 0; i <= 1; ++i) {
            pconVersionBuilder.append(".");
            if (vc.length >= i + 1) {
                pconVersionBuilder.append(vc[i]);
                continue;
            }
            pconVersionBuilder.append("0");
        }
        return pconVersionBuilder.toString();
    }

    @Transactional
    public ServerResponse processMessage(ObjectNode pdmMessageJson, String srcProtocol) {
        return (ServerResponse)Observation.createNotStarted((String)"pdm.control.message", (ObservationRegistry)this.observationRegistry).contextualName("process-message").lowCardinalityKeyValue("type", this.guessMessageType(pdmMessageJson)).highCardinalityKeyValue("pdm", String.valueOf(pdmMessageJson.get("GAC")) + "/" + String.valueOf(pdmMessageJson.get("PSA")) + "/" + String.valueOf(pdmMessageJson.get("DTM"))).observe(() -> this.processMessageObserved((PdmMessageRawDto)this.pdmObjectMapper.convertValue((Object)pdmMessageJson, PdmMessageRawDto.class), srcProtocol));
    }

    private String guessMessageType(ObjectNode m) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{m.get("BET"), m.get("TRC")})) {
            return "payment";
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{m.get("MNR"), m.get("TRC")})) {
            return "status";
        }
        if (m.get("KAI") != null) {
            return "keep-alive";
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{m.get("ABN"), m.get("TRC")})) {
            return "clearing";
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{m.get("SNR"), m.get("TRC")})) {
            return "system";
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{m.get("MRQ"), m.get("REQ")})) {
            return "request";
        }
        if (m.get("UTY") != null || ObjectUtils.anyNotNull((Object[])new Object[]{m.get("FMD"), m.get("FDD"), m.get("FXD")}) || ObjectUtils.anyNotNull((Object[])new Object[]{m.get("FML"), m.get("DLT"), m.get("FXL"), m.get("FDL")})) {
            return "fw-update";
        }
        return "other";
    }

    public ServerResponse processMessageObserved(PdmMessageRawDto frameworkMessage, String srcProtocol) {
        PdmMessageDto mm = new PdmMessageDto(this.loadPdm(frameworkMessage), frameworkMessage, this.messageParserHelper);
        PdmRuntimeMonitor pdmRtm = this.aliveMonitorService.provideRuntimeMonitor(mm.getPdm());
        if (ObjectUtils.allNotNull((Object[])new Object[]{mm.getUty(), mm.getFsa(), mm.getFsi()})) {
            return this.fwdsFactory.getService("TCP").getFilePart(mm);
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{mm.getFmd(), mm.getFdd(), mm.getFxd()})) {
            return this.fwdsFactory.getService("UDP").getFilePart(mm);
        }
        ServerResponseJson serverResponse = new ServerResponseJson();
        boolean messageRejected = false;
        if (mm.getBet() != null && mm.getTrc() != null) {
            Optional payment = mm.getEid().isPresent() ? this.processParkingExtension(mm, pdmRtm) : this.processPayment(mm, pdmRtm);
            if (payment.isPresent() && mm.getCpf() != null) {
                this.cpfService.createCpf((PaymentTransaction)payment.get(), mm.getCpf());
                mm.clearCpf();
            }
            messageRejected = payment.isEmpty();
            payment.ifPresent(arg_0 -> ((PaymentTransactionRepository)this.paymentRepo).save(arg_0));
            payment.ifPresent(arg_0 -> ((PaymentForeignRetisterService)this.paymentTransportService).registerPayment(arg_0));
        } else if (mm.getMnr() != null && mm.getTrc() != null) {
            this.processStatusMessage(mm, srcProtocol, pdmRtm);
        } else if (mm.getKai() != null) {
            this.processKeepAlive7(mm, "TCP", serverResponse, pdmRtm);
        } else if (mm.getAbn() != null && mm.getTrc() != null) {
            this.processClearing(mm, pdmRtm);
        } else if (mm.getUty() != null && mm.getFsa() == null && mm.getFsi() == null) {
            logger.debug("~ File metadata request (TCP)");
            this.fwdsFactory.getService("TCP").getMetaData(mm, serverResponse);
        } else if (ObjectUtils.anyNotNull((Object[])new Object[]{mm.getFml(), mm.getDlt(), mm.getFxl(), mm.getFdl()})) {
            logger.debug("~ File metadata request (UDP)");
            this.fwdsFactory.getService("UDP").getMetaData(mm, serverResponse);
        }
        if (!messageRejected) {
            this.modemLoginService.procesModemSignalAndLogin(mm, pdmRtm);
            this.powerMonitorService.processPowerReprot(mm, pdmRtm);
            this.hwPartsMonitorService.processHardwareComponents(mm);
            this.hwRuntimeMonitorService.processRuntimeReport(mm);
            this.tariffSevice.processTariffReport(mm);
            this.printerService.processPapereRoleChanged(mm);
            this.printerService.processPaperUsageReport(mm);
            this.paymentService.processCustomPaymentField(mm);
            this.logService.processActionLog(mm);
            this.processRealTimeRequests(mm, serverResponse);
        }
        if (frameworkMessage.gac() != null) {
            serverResponse.append("ROK", (Object)"");
        }
        this.appendStandardAnswerMnemonics(serverResponse, mm.getPdm(), mm.getTimeZone(), mm.getTrc(), mm.getVer());
        return serverResponse;
    }

    private void processStatusMessage(PdmMessageDto m, String srcProtocol, PdmRuntimeMonitor pdmRtm) {
        if (!this.trcCheckService.isStatusTrcNew(m.getPdm(), m.getTrc().intValue())) {
            return;
        }
        if (m.getMnr() == 6000) {
            logger.debug("~ PDM5 Keep alive, {} min", (Object)m.getKai().toMinutes());
            this.aliveMonitorService.recievedAliveMessage(pdmRtm, m.getKai());
            return;
        }
        logger.debug("~ Status {}.", (Object)m.getMnr());
        FirmwareDownloadService fwDownloadService = this.fwdsFactory.getService(srcProtocol);
        StatusMessage statusMessage = this.staustService.insertPmdMessage(m);
        this.aliveMonitorService.recievedStatusMessage(pdmRtm, m.getDatTim(), m.getTrc().intValue(), (int)m.getMnr().shortValue());
        if (FirmwareDownloadServiceHelper.DOWNLOAD_MESSAGE_NUMBERS.contains(m.getMnr())) {
            DownloadTarget downloadTarget = FirmwareDownloadServiceHelper.extractDownloadTarget((int)m.getMnr().shortValue(), (Integer)m.getUty());
            fwDownloadService.updateTransferStatus(m, downloadTarget);
        }
        if (m.getCmd() != null) {
            logger.debug("~ Resolved remote action {}.", (Object)m.getCmd());
            this.remoteActionService.resolve(m.getPdm(), m.getCmd().intValue(), statusMessage);
        }
    }

    private void processKeepAlive7(PdmMessageDto m, String srcProtocol, ServerResponseJson response, PdmRuntimeMonitor pdmRtm) {
        logger.debug("~ Keep alive, {} min", (Object)m.getKai().toMinutes());
        this.aliveMonitorService.recievedAliveMessage(pdmRtm, m.getKai());
        FirmwareDownloadService fwDownloadService = this.fwdsFactory.getService(srcProtocol);
        fwDownloadService.checkDownload(m.getPdm(), response);
        if (this.remoteActionService.check(m.getPdm())) {
            RemoteActionSevice.NextRemoteAction nextAct = this.remoteActionService.next(m.getPdm());
            response.append("CMD", (Object)nextAct.getCode());
            if (nextAct.getParameters() != null) {
                response.append("CAR", (Object)PdmTextEncoder.encode((String)nextAct.getParameters()));
            }
            response.append("WTS", (Object)nextAct.getSubmitEpochMilis());
            response.append("IPN", (Object)fwDownloadService.getWanIpHex());
            response.append("PRT", (Object)fwDownloadService.getWanPortHex());
        }
    }

    private Optional<PaymentTransaction> processParkingExtension(PdmMessageDto m, PdmRuntimeMonitor pdmRtm) {
        if (!this.trcCheckService.isPaymentTrcNew(m.getPdm(), m.getTrc().intValue())) {
            return Optional.empty();
        }
        logger.debug("~ Parking extension");
        this.cashBoxLevelSerivice.addPayment(m.getPdm(), m.getBza(), m.getStp(), m.getWkz(), m.getBet());
        PaymentTransaction pt = this.paymentService.persistParkingTicketExtension(m);
        this.aliveMonitorService.recievedPaymentMessage(pdmRtm, m.getTrc().intValue());
        return Optional.of(pt);
    }

    private Optional<PaymentTransaction> processPayment(PdmMessageDto mm, PdmRuntimeMonitor pdmRtm) {
        if (!this.trcCheckService.isPaymentTrcNew(mm.getPdm(), mm.getTrc().intValue())) {
            return Optional.empty();
        }
        try {
            PaymentTransaction tr = this.paymentService.process(mm);
            mm.setPayment(tr);
            this.cashBoxLevelSerivice.addPayment(mm.getPdm(), tr.getPaymentType(), tr.getPaymentReason(), tr.getCurrency(), tr.getAmount());
            this.aliveMonitorService.recievedPaymentMessage(pdmRtm, mm.getTrc().intValue());
            return Optional.of(tr);
        }
        catch (PdmMessageDuplicated e) {
            return Optional.empty();
        }
    }

    private void processClearing(PdmMessageDto m, PdmRuntimeMonitor pdmRtm) {
        logger.debug("~ Cash clearing");
        if (!this.trcCheckService.isClearingTrcNew(m.getPdm(), m.getTrc().intValue())) {
            return;
        }
        if (m.isEst()) {
            logger.debug("PDM5 revenue statistic is ignored.");
        } else {
            this.aliveMonitorService.recievedClearingMessage(pdmRtm, m.getTrc().intValue());
            if (m.getBza() != null) {
                this.cashBoxLevelSerivice.resetPayments(m.getPdm(), m.getBza(), m.getWkz(), m.getDatTim());
            } else {
                this.clearingService.parsePdm5Clearing(m).forEach(clr -> this.cashBoxLevelSerivice.resetPayments(m.getPdm(), clr.getPaymentType(), m.getWkz(), m.getDatTim()));
            }
            this.clearingService.persistCashBoxClearingMessage(m);
        }
    }

    private void processRealTimeRequests(PdmMessageDto m, ServerResponseJson response) {
        Observation observation = Observation.createNotStarted((String)"pdm.control.req", (ObservationRegistry)this.observationRegistry).contextualName("real-time-request");
        if (m.getReq() != null) {
            logger.debug("~ Real time request");
            Consumer<Map.Entry> appendMnemonic = es -> {
                String key = (String)es.getKey();
                Object val = es.getValue();
                if (val instanceof String) {
                    String v = (String)val;
                    response.append(key, (Object)v);
                } else if (val instanceof Integer) {
                    Integer v = (Integer)val;
                    response.append(key, (Object)v);
                } else if (val instanceof Long) {
                    Long v = (Long)val;
                    response.append(key, (Object)v);
                } else {
                    try {
                        response.append(key, (Object)this.pdmObjectMapper.writeValueAsString(val));
                    }
                    catch (JsonProcessingException e) {
                        logger.warn("Real time request cannot be parsed, therefore it will be ignored. Rest of message will be processed normally.", (Throwable)e);
                    }
                }
            };
            observation.lowCardinalityKeyValue("request", m.getReq().toString()).lowCardinalityKeyValue("source", "single").observe(() -> this.realTimeRequestService.execute(m.getReq().intValue(), m, Map.of()).map(resp -> resp.entrySet().stream()).ifPresent(entryStream -> entryStream.forEach(appendMnemonic)));
        }
        if (!m.getRealTimeRequests().isEmpty()) {
            logger.debug("~ Real time multi-request");
            try {
                int groupSize = m.getRealTimeRequests().size();
                ArrayList responseList = new ArrayList(groupSize);
                for (Map reqMap : m.getRealTimeRequests()) {
                    Integer reqId = (Integer)reqMap.get("REQ");
                    observation.lowCardinalityKeyValue("request", reqId.toString()).lowCardinalityKeyValue("source", "group").lowCardinalityKeyValue("group-size", Integer.toString(groupSize)).observe(() -> this.realTimeRequestService.execute(reqId.intValue(), m, reqMap).ifPresent(responseList::add));
                }
                response.append("MRQ", (Object)this.pdmObjectMapper.writeValueAsString(responseList));
            }
            catch (JsonProcessingException e) {
                logger.warn("Real time multi request cannot be parsed, therefore it will be ignored. Rest of message will be processed normally.", (Throwable)e);
            }
        }
    }

    @Transactional(readOnly=true)
    public Pdm loadPdm(PdmMessageRawDto req) {
        Pdm pdm = null;
        pdm = req.gac() != null ? this.pdmRepo.findByNumberAndZoneAreaId(req.psa().intValue(), req.gac().intValue()).orElseGet(() -> {
            Pdm newPdm = this.pdmService.createPdm(req.psa().intValue(), req.gac().intValue());
            return (Pdm)this.pdmRepo.getReferenceById((Object)newPdm.getId());
        }) : (Pdm)this.pdmService.findPdmByNumberAndCpuId(req.psa().intValue(), req.pid()).orElseThrow();
        return pdm;
    }

    public final void appendStandardAnswerMnemonics(ServerResponseJson response, Pdm pdm, ZoneId timeZone, Integer trc, String pdmVersion) {
        if (timeZone != null) {
            int[] fwVersion = MessageParserHelper.parseFwVersion((String)pdmVersion);
            LocalDateTime pdmNow = ZonedDateTime.now(timeZone).toLocalDateTime();
            Object tilValue = pdmNow.format(new DateTimeFormatterBuilder().appendPattern("HHmmss").toFormatter());
            tilValue = fwVersion != null && fwVersion.length >= 1 && fwVersion[0] == 7 ? (String)tilValue + String.format("%02d", pdmNow.get(ChronoField.DAY_OF_WEEK) % 7) : (String)tilValue + String.format("%02d", (pdmNow.get(ChronoField.DAY_OF_WEEK) - 1) % 7);
            response.append("TIL", tilValue);
            response.append("DAT", (Object)pdmNow.toLocalDate().format(DateTimeFormats.PDM_DATE_FORMATTER));
            response.append("TIM", (Object)pdmNow.toLocalTime().format(DateTimeFormats.PDM_TIME_FORMATTER));
        }
        if (trc != null) {
            response.append("TRC", (Object)String.format("%06d", trc));
        }
        if (pdm != null) {
            response.append("PSA", (Object)String.format("%05d", pdm.getNumber()));
            response.append("GAC", (Object)pdm.getZone().getArea().getId());
        }
        response.append("PVR", (Object)this.pconVesrionString);
    }
}

