/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.parking_extension;

import de.rtb.pcon.core.parking_extension.ExtendiblePermit;
import de.rtb.pcon.core.services.pdm_in.ExtensiblePermitDbId;
import de.rtb.pcon.model.Area;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
class ParkingExtensionRepo {
    @PersistenceContext
    private EntityManager entityManager;

    ParkingExtensionRepo() {
    }

    @Transactional(readOnly=true)
    public List<ExtendiblePermit> findExtendiblePayments(int areaNr, String lpn, Integer psn) {
        Query query;
        Area area = (Area)this.entityManager.find(Area.class, (Object)areaNr);
        ZoneId userTimeZone = ZoneId.of(area.getTimeZoneName());
        if (lpn != null && psn == null) {
            query = this.entityManager.createNativeQuery("SELECT * FROM %s.extendible_permits(:areaNr, :lpn, null)".formatted("control"), Tuple.class).setParameter("areaNr", (Object)areaNr).setParameter("lpn", (Object)lpn);
        } else if (lpn == null && psn != null) {
            query = this.entityManager.createNativeQuery("SELECT * FROM %s.extendible_permits(:areaNr, null, :psn)".formatted("control"), Tuple.class).setParameter("areaNr", (Object)areaNr).setParameter("psn", (Object)psn);
        } else {
            throw new IllegalStateException("Exactly one of arguments (lpn, psn) has to be non null");
        }
        List resultDb = query.getResultList();
        ArrayList<ExtendiblePermit> result = new ArrayList<ExtendiblePermit>(resultDb.size());
        for (Tuple o : resultDb) {
            ExtendiblePermit p = new ExtendiblePermit();
            Instant payInstant = (Instant)o.get("res_pay_date_time", Instant.class);
            Integer payTrc = (Integer)o.get("res_trc", Integer.class);
            Instant parkEndInstant = (Instant)o.get("res_exp_date_time", Instant.class);
            Integer pdmId = (Integer)o.get("res_pdm_id", Integer.class);
            ExtensiblePermitDbId paymentId = new ExtensiblePermitDbId(pdmId, payInstant, payTrc);
            p.setPaymentId(paymentId);
            p.setPrice(((BigDecimal)o.get("res_base_price", BigDecimal.class)).add((BigDecimal)o.get("res_ext_price", BigDecimal.class)));
            p.setStart(ZonedDateTime.ofInstant(payInstant, userTimeZone).toLocalDateTime());
            p.setEnd(ZonedDateTime.ofInstant(parkEndInstant, userTimeZone).toLocalDateTime());
            p.setTariffName((String)o.get("res_tariff_name", String.class));
            p.setPermitNumber(((Integer)o.get("res_base_permit_nr", Integer.class)).intValue());
            p.setSellingPdmNumber(((Integer)o.get("res_pdm_number", Integer.class)).intValue());
            p.setSellingPdmName((String)o.get("res_pdm_name", String.class));
            p.setTolerance(((Integer)o.get("res_tolerance_time", Integer.class)).intValue());
            p.setPenaltyFee((BigDecimal)o.get("res_penalty_value", BigDecimal.class));
            p.setParts(((Integer)o.get("res_parts", Integer.class)).intValue());
            p.setMaxParts(((Integer)o.get("res_max_permits", Integer.class)).intValue());
            p.setMaxDuration(((Integer)o.get("res_max_duration", Integer.class)).intValue());
            p.setMaxPrice((BigDecimal)o.get("res_max_price", BigDecimal.class));
            result.add(p);
        }
        return result;
    }
}

