/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.notification;

import de.rtb.pcon.core.msg_fw.MessageForwardingRuleDefinition;
import de.rtb.pcon.core.notification.MailSenderService;
import de.rtb.pcon.core.notification.NotificationMessageMail;
import de.rtb.pcon.core.notification.NotificationMessageSms;
import de.rtb.pcon.core.notification.NotificationSenderThread;
import de.rtb.pcon.core.notification.TemplatingEngineService;
import de.rtb.pcon.core.notification.sms.SmsService;
import de.rtb.pcon.core.notification.sms.SmsUtils;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.model.appmanagement.User;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NotificationService
implements HealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(NotificationService.class);
    private static final int QUEUE_LENTGTH = 500;
    private static final Pattern EMAIL_PATTERN = Pattern.compile("((?<type>(\\w+)):)?(?<email>[\\w\\d\\.\\-_]+@[\\w\\d\\.\\-_]+)");
    private static final Pattern PHONE_PATTERN = Pattern.compile("\\+?[\\d\\s\\(\\)\\-]+");
    private BlockingQueue<NotificationMessageMail> mailQueue = new LinkedBlockingQueue(500);
    private BlockingQueue<NotificationMessageSms> smsQueue = new LinkedBlockingQueue(500);
    private NotificationSenderThread<NotificationMessageMail> mailSender;
    private NotificationSenderThread<NotificationMessageSms> smsSender;
    @Autowired
    private SmsService smsService;
    @Autowired
    private MailSenderService mailSenderService;
    @Autowired
    private TemplatingEngineService templatingEngineService;

    @PostConstruct
    void intit() {
        this.mailSender = new NotificationSenderThread("mail-sender", this.mailQueue, arg_0 -> ((MailSenderService)this.mailSenderService).sendMessage(arg_0));
        this.smsSender = new NotificationSenderThread("sms-sender", this.smsQueue, msg -> this.smsService.send(msg.getReceiver(), msg.getText()));
        this.mailSender.start();
        this.smsSender.start();
        log.info("Notification service started.");
        log.trace(" + Mail queue capacity {}.", (Object)this.mailQueue.remainingCapacity());
        log.trace(" + SMS  queue capacity {}.", (Object)this.smsQueue.remainingCapacity());
    }

    @PreDestroy
    public void stop() {
        log.info("Waiting for {} e-mails and {} SMS to be sent (max 1 minute).", (Object)this.mailQueue.size(), (Object)this.smsQueue.size());
        try {
            this.mailSender.shutDown();
            this.mailSender.join(600000L);
            log.info("All e-mails has been sent.");
        }
        catch (InterruptedException e) {
            log.error("Failed to finish mail sender properly. Some messages may be lost.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            this.smsSender.shutDown();
            this.smsSender.join(600000L);
            log.info("All SMS has been sent.");
        }
        catch (InterruptedException e) {
            log.error("Failed to finish SMS sender properly. Some messages may be lost.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        log.info("Notification service finished.");
    }

    public void sendEmail(String recipients, String subject, String body) {
        String receiversReal = NotificationService.splitRecievers((String)recipients).stream().collect(Collectors.joining(" "));
        if (log.isTraceEnabled() && !StringUtils.equals((CharSequence)recipients, (CharSequence)receiversReal)) {
            log.trace("Real receiver is '{}'.", (Object)receiversReal);
        }
        this.sendEmail(this.templatingEngineService.composePlainTextMessage(receiversReal, subject, body));
    }

    public void sendEmail(MimeMessage mimeMessage) {
        try {
            this.mailQueue.add(NotificationMessageMail.forHuman((MimeMessage)mimeMessage));
            if (log.isDebugEnabled()) {
                String recepients = Arrays.stream(mimeMessage.getAllRecipients()).map(Address::toString).collect(Collectors.joining(","));
                log.debug("E-mail for '{}' added to a queue. There are {} e-mails waiting.", (Object)recepients, (Object)this.mailQueue.size());
            }
        }
        catch (Exception e) {
            log.error("Failed to add an e-mail to queue.", (Throwable)e);
        }
    }

    public void sendServiceEmail(String recievers, String subject, String text) {
        String hostName = "<unknown>";
        String inetAddressStr = "<unknown>";
        try {
            InetAddress inetAdress = InetAddress.getLocalHost();
            inetAddressStr = inetAdress.toString();
            hostName = inetAdress.getHostName();
        }
        catch (UnknownHostException inetAdress) {
            // empty catch block
        }
        String subjectNew = String.format("[PControl %s (%s)] %s", hostName, inetAddressStr, subject);
        this.sendEmail(recievers, subjectNew, text);
    }

    public void sendSms(String reciever, String text) {
        if (reciever == null || reciever.isEmpty()) {
            log.error("SMS cannot be sent because the phone number is empty.");
            return;
        }
        NotificationMessageSms m = NotificationMessageSms.forHuman((String)reciever, (String)text);
        try {
            this.smsQueue.add(m);
            log.debug("SMS for '{}' added to a queue. There are {} SMSs waiting.", (Object)m.getReceiver(), (Object)this.smsQueue.size());
        }
        catch (Exception e) {
            log.error("Failed to add a SMS to queue.", (Throwable)e);
        }
    }

    public void sendStatusForwarding(MessageForwardingRuleDefinition rule, StatusMessage status) {
        log.info("Status forwarding rule '{}' triggered.", (Object)rule.name());
        List recepients = NotificationService.splitRecievers((String)rule.receivers());
        HashMap<Message.RecipientType, List> emails = new HashMap<Message.RecipientType, List>();
        LinkedList<String> sms = new LinkedList<String>();
        for (String recipient : recepients) {
            Matcher matcher = EMAIL_PATTERN.matcher(recipient);
            if (matcher.matches()) {
                emails.computeIfAbsent(NotificationService.stringToRecipientType((String)matcher.group("type")), k -> new LinkedList()).add(matcher.group("email"));
                continue;
            }
            matcher = PHONE_PATTERN.matcher(recipient);
            if (matcher.matches()) {
                sms.add(recipient);
                continue;
            }
            log.warn("Unsupported recipient '{}'. Message was not sent.", (Object)recipient);
        }
        if (emails.size() > 0) {
            this.sendEmail(this.templatingEngineService.composeStatusForwardingMimeMessage(emails, rule, status));
        }
        sms.forEach(phoneNr -> {
            String smsText = this.templatingEngineService.composeStatusForwardingSMS(rule, status);
            smsText = SmsUtils.toGsm((String)smsText);
            this.sendSms(phoneNr, smsText);
        });
    }

    public static List<String> splitRecievers(String recipients) {
        String[] recipientArray = StringUtils.split((String)recipients, (String)",; ");
        return Arrays.stream(recipientArray).map(String::trim).filter(s -> !s.isEmpty()).toList();
    }

    public static Message.RecipientType stringToRecipientType(String str) {
        if (str == null) {
            str = "TO";
        }
        return switch (str.toUpperCase()) {
            case "TO" -> Message.RecipientType.TO;
            case "CC" -> Message.RecipientType.CC;
            case "BCC" -> Message.RecipientType.BCC;
            default -> {
                log.warn("Unknown recipient type '{}'. Using 'TO' instead.", (Object)str);
                yield Message.RecipientType.TO;
            }
        };
    }

    public void sendExportJobDone(File resultFile, User owner, Locale locale) {
        try {
            MimeMessage msg = this.templatingEngineService.composeLogbookExportMail(resultFile, owner, locale);
            this.sendEmail(msg);
        }
        catch (Exception e) {
            log.error("Cannot create or send e-mail message to send.", (Throwable)e);
        }
    }

    public Health health() {
        List<NotificationSenderThread> threads = List.of(this.mailSender, this.smsSender);
        boolean sendersAlive = threads.stream().map(NotificationSenderThread::isOk).reduce(true, Boolean::logicalAnd);
        if (sendersAlive) {
            return Health.up().build();
        }
        Health.Builder healtBuilder = Health.down();
        threads.forEach(sender -> {
            if (!sender.isOk()) {
                LinkedHashMap<String, Object> report = new LinkedHashMap<String, Object>();
                report.put("alive", sender.isAlive());
                if (this.mailSender.getLastEcException() != null) {
                    report.put("error", sender.getLastEcException().getMessage());
                } else {
                    report.put("error", "unknown");
                }
                report.put("waiting messages", sender.numberOfMessagesInQueue());
                report.put("recovery in (s)", sender.resumedIn().getSeconds());
                healtBuilder.withDetail(sender.getName(), report);
            }
        });
        return healtBuilder.build();
    }
}

