/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_presistence;

import de.rtb.pcon.core.events.PaymentReceivedEvent;
import de.rtb.pcon.core.integration.PdmMessageDuplicated;
import de.rtb.pcon.model.PaymentTransaction;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaymentTransactionPersitenceService {
    @PersistenceContext
    private EntityManager entityManager;
    private final ApplicationEventPublisher applicationEventPublisher;

    public PaymentTransactionPersitenceService(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void insertToDb(PaymentTransaction p) {
        try {
            this.entityManager.persist((Object)p);
            this.entityManager.flush();
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new PaymentReceivedEvent((Object)this, p));
        }
        catch (ConstraintViolationException e) {
            throw new PdmMessageDuplicated("Primary key of the payment already exist", (Throwable)e);
        }
    }
}

