/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download.ui.file;

import de.rtb.pcon.core.fw_download.ui.file.FirmwareFileController;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.SoftwareDescription;
import de.rtb.pcon.model.download.SoftwarePath;
import de.rtb.pcon.repositories.fw_update.DownloadEntryRepository;
import de.rtb.pcon.repositories.fw_update.SoftwareDescriptionRepository;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(path={"/api/pcon/ui/fw-update/files"})
class FirmwareFileController {
    private static final Logger log = LoggerFactory.getLogger(FirmwareFileController.class);
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DownloadEntryRepository downloadEntryRepo;
    @Autowired
    private SoftwareDescriptionRepository softwareDescriptionRepo;
    Predicate<SoftwareDescription> canUserDownloadFile = swd -> {
        if (swd.getArea() == null) {
            return true;
        }
        return this.securityService.hasRightFor(swd.getArea());
    };

    FirmwareFileController() {
    }

    @GetMapping(value={"download/entry/{id}"})
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ROLE_PCON_SOFTWARE_MANAGE')")
    public void downloadEntry(HttpServletResponse response, @PathVariable(value="id") int id) {
        this.downloadEntryRepo.findById((Object)id).filter(de -> this.securityService.hasRightFor(de.getPdm())).ifPresentOrElse(de -> this.writeDownloadEntry(de, response), () -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"download/software/{id}"})
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ROLE_PCON_SOFTWARE_MANAGE')")
    public void downloadSoftware(HttpServletResponse response, @PathVariable(value="id") int id) {
        this.softwareDescriptionRepo.findById((Object)id).filter(this.canUserDownloadFile).ifPresentOrElse(swd -> this.writeSoftwareDescription(swd, response), () -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    private void setResponseHeaders(HttpServletResponse response, SoftwareDescription swd) {
        response.setContentType("application/octet-stream");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Date", ZonedDateTime.now(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME));
        response.setHeader("Content-Disposition", "attachment; filename=" + swd.getFileName());
    }

    private void writeDownloadEntry(DownloadEntry de, HttpServletResponse response) {
        DownloadPlan plan = de.getPlan();
        SoftwareDescription swd = plan.getSoftwareDescription();
        this.setResponseHeaders(response, swd);
        switch (1.$SwitchMap$de$rtb$pcon$model$download$DeviceType[swd.getDeviceType().ordinal()]) {
            case 1: {
                this.outputFirmware(swd, response);
                break;
            }
            case 2: {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{de.getPath()})) {
                    String fileName = de.getPath().replace('/', '_') + ".pdm";
                    response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
                }
                this.outputSingleSoftware(swd, de.getPath(), response);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.outputSingleSoftware(swd, null, response);
                break;
            }
            default: {
                throw new IllegalStateException("Download of file type '" + String.valueOf(swd.getDeviceType()) + "' is not supported.");
            }
        }
    }

    private void writeSoftwareDescription(SoftwareDescription swd, HttpServletResponse response) {
        this.setResponseHeaders(response, swd);
        switch (1.$SwitchMap$de$rtb$pcon$model$download$DeviceType[swd.getDeviceType().ordinal()]) {
            case 1: {
                this.outputFirmware(swd, response);
                break;
            }
            case 2: {
                if (swd.getFileName().endsWith(".pdm")) {
                    log.debug("Writing '{}' single configuration '{}' => {}.", new Object[]{swd.getModel(), swd.getVersion(), swd.getFileName()});
                    this.outputSingleSoftware(swd, null, response);
                    break;
                }
                log.debug("Writing '{}' configuration bundle '{}' => {}.", new Object[]{swd.getModel(), swd.getVersion(), swd.getFileName()});
                this.writeSoftwareBundle(swd, p -> p + ".pdm", response);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.outputSingleSoftware(swd, null, response);
                break;
            }
            default: {
                throw new IllegalStateException("Writing of software of type '" + String.valueOf(swd.getDeviceType()) + "' is not supported.");
            }
        }
    }

    private void outputSingleSoftware(SoftwareDescription swDesc, String singlePath, HttpServletResponse response) {
        Optional<Object> swItem = StringUtils.isBlank((CharSequence)singlePath) ? swDesc.getSoftwarePaths().stream().findAny() : swDesc.getSoftwarePaths().stream().filter(p -> p.getPath().equals(singlePath)).findAny();
        swItem.ifPresentOrElse(swPath -> this.copyBlob(swPath.getSoftwareItem().getData(), response), () -> response.setStatus(HttpStatus.NOT_FOUND.value()));
    }

    private void outputFirmware(SoftwareDescription swDesc, HttpServletResponse response) {
        if (swDesc.getSoftwarePaths().size() == 1) {
            this.outputSingleSoftware(swDesc, null, response);
        } else {
            log.debug("Writing '{}' firmware '{}' => {}.", new Object[]{swDesc.getModel(), swDesc.getVersion(), swDesc.getFileName()});
            this.writeSoftwareBundle(swDesc, p -> "pp0_" + p + ".h66", response);
        }
    }

    private void copyBlob(Blob blob, HttpServletResponse response) {
        try {
            response.setContentLength((int)blob.length());
            IOUtils.copy((InputStream)blob.getBinaryStream(), (OutputStream)response.getOutputStream());
        }
        catch (IOException | SQLException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Cannot copy stream from database.");
        }
    }

    private void writeSoftwareBundle(SoftwareDescription swd, UnaryOperator<String> zipEntryNameProvider, HttpServletResponse response) {
        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
            for (SoftwarePath swp : swd.getSoftwarePaths()) {
                ZipEntry zipEntry = new ZipEntry((String)zipEntryNameProvider.apply(swp.getPath()));
                zipEntry.setSize(swp.getSoftwareItem().getData().length());
                zipOut.putNextEntry(zipEntry);
                if (log.isTraceEnabled()) {
                    String fileSize = FileUtils.byteCountToDisplaySize((long)zipEntry.getSize());
                    log.trace("Created ZIP entry `{}`, {}", (Object)zipEntry.getName(), (Object)fileSize);
                }
                IOUtils.copy((InputStream)swp.getSoftwareItem().getData().getBinaryStream(), (OutputStream)zipOut);
            }
            zipOut.flush();
        }
        catch (IOException | SQLException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Cannot compress PDM5 firmware");
        }
    }
}

