/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.config.general;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Component
public class LoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.logRequest(request, body);
        ClientHttpResponse response = execution.execute(request, body);
        this.logResponse(response);
        return response;
    }

    private void logRequest(HttpRequest request, byte[] body) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("===log request start===");
            log.debug("URI: {}", (Object)request.getURI());
            log.debug("Method: {}", (Object)request.getMethod());
            log.debug("Headers: {}", (Object)request.getHeaders());
            log.debug("Request body: {}", (Object)new String(body, "UTF-8"));
            log.debug("===log request end===");
        }
    }

    private void logResponse(ClientHttpResponse response) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("===log response start===");
            log.debug("Status code: {}", (Object)response.getStatusCode());
            log.debug("Status text: {}", (Object)response.getStatusText());
            log.debug("Headers: {}", (Object)response.getHeaders());
            log.debug("Response body: {}", (Object)StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.defaultCharset()));
            log.debug("===log response end===");
        }
    }
}

